/*
 * Decompiled with CFR 0.152.
 */
package systems.brn.textvoice.client.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class Speaker {
    private final int sampleRate;
    private SourceDataLine line;
    private Mixer.Info currentMixer;

    public Speaker(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void open(Mixer.Info mixerInfo) throws LineUnavailableException {
        this.close();
        this.currentMixer = mixerInfo;
        AudioFormat format = new AudioFormat(this.sampleRate, 16, 1, true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        this.line = (SourceDataLine)AudioSystem.getLine(info);
        if (mixerInfo != null) {
            this.line = (SourceDataLine)AudioSystem.getMixer(mixerInfo).getLine(info);
        }
        this.line.open(format);
        this.line.start();
    }

    public void play(short[] pcm) {
        if (this.line == null) {
            return;
        }
        byte[] buffer = new byte[pcm.length * 2];
        for (int i = 0; i < pcm.length; ++i) {
            buffer[i * 2] = (byte)(pcm[i] & 0xFF);
            buffer[i * 2 + 1] = (byte)(pcm[i] >> 8 & 0xFF);
        }
        this.line.write(buffer, 0, buffer.length);
    }

    public void close() {
        if (this.line != null) {
            this.line.flush();
            this.line.stop();
            this.line.close();
            this.line = null;
        }
    }

    public void setDevice(Mixer.Info mixerInfo) throws LineUnavailableException {
        this.open(mixerInfo);
    }

    public Mixer.Info getCurrentMixer() {
        return this.currentMixer;
    }
}

