/*
 * Decompiled with CFR 0.152.
 */
package systems.brn.textvoice.client;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import systems.brn.textvoice.client.PlayerHUDState;
import systems.brn.textvoice.client.audio.Speaker;

public class PlayerAudioMixer {
    private final Speaker speaker;
    private final Map<String, Queue<short[]>> streams = new ConcurrentHashMap<String, Queue<short[]>>();
    private final int frameSamples = 160;
    private final int sampleRate = 8000;
    private final Map<String, PlayerHUDState> hudStates;
    private volatile short masterVolume = (short)100;

    public PlayerAudioMixer(Speaker speaker, Map<String, PlayerHUDState> hudStates) {
        this.speaker = speaker;
        this.hudStates = hudStates;
    }

    public void setMasterVolume(short volume) {
        if (volume < 0) {
            volume = 0;
        }
        if (volume > 100) {
            volume = (short)100;
        }
        this.masterVolume = volume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueuePlayerFrame(String playerName, short[] pcm) {
        Queue queue;
        Queue queue2 = queue = this.streams.computeIfAbsent(playerName, k -> new LinkedList());
        synchronized (queue2) {
            queue.add(pcm);
        }
    }

    public void start() {
        Thread thread = new Thread(() -> {
            short[] outputBuffer = new short[160];
            long nextFrameTime = System.nanoTime();
            while (true) {
                float[] mixBuffer = new float[160];
                Arrays.fill(mixBuffer, 0.0f);
                for (Map.Entry<String, Queue<short[]>> entry : this.streams.entrySet()) {
                    String playerName = entry.getKey();
                    Queue<short[]> queue = entry.getValue();
                    short[] frame = null;
                    Queue<short[]> queue2 = queue;
                    synchronized (queue2) {
                        if (!queue.isEmpty()) {
                            frame = queue.poll();
                        }
                    }
                    if (frame == null) continue;
                    PlayerHUDState state = this.hudStates.computeIfAbsent(playerName, k -> new PlayerHUDState());
                    float playerVolume = (float)state.volume / 100.0f;
                    for (int i = 0; i < Math.min(frame.length, mixBuffer.length); ++i) {
                        int n = i;
                        mixBuffer[n] = mixBuffer[n] + (float)frame[i] * playerVolume;
                    }
                }
                float masterVol = (float)this.masterVolume / 100.0f;
                for (int i = 0; i < 160; ++i) {
                    float sample = mixBuffer[i] * masterVol;
                    if (sample > 32767.0f) {
                        sample = 32767.0f;
                    }
                    if (sample < -32768.0f) {
                        sample = -32768.0f;
                    }
                    outputBuffer[i] = (short)sample;
                }
                this.speaker.play(outputBuffer);
                long sleepTime = ((nextFrameTime += 20000000L) - System.nanoTime()) / 1000000L;
                if (sleepTime <= 0L) continue;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }, "textvoice-Mixer");
        thread.setDaemon(true);
        thread.start();
    }
}

