/*
 * Decompiled with CFR 0.152.
 */
package systems.brn.textvoice.client;

import com.mojang.authlib.GameProfile;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_7471;
import org.jetbrains.annotations.Nullable;
import systems.brn.textvoice.client.Codec2Wrapper;
import systems.brn.textvoice.client.PlayerAudioMixer;
import systems.brn.textvoice.client.PlayerHUDState;
import systems.brn.textvoice.client.PlayerReceiveBuffer;
import systems.brn.textvoice.client.SafeBMPCodec;

public class TextVoiceHandler {
    public static final char START_MARKER = '\ud7f0';
    public static final char END_MARKER = '\ud7f1';
    public static final char FRAME_SEPARATOR = '\ud7f2';
    public static final char PTT_PLAY_MARKER = '\ud7f3';
    public static final int MAX_ENCODED_LEN = 236;
    public final PlayerAudioMixer mixer;
    public final List<short[]> pttSendBuffer = new ArrayList<short[]>();
    public final Map<String, PlayerReceiveBuffer> receiveBuffers = new ConcurrentHashMap<String, PlayerReceiveBuffer>();
    private final Map<String, PlayerHUDState> hudStates;
    private volatile boolean pttActive = false;
    private final Object pttLock = new Object();
    public String targetPlayer = null;
    public final Codec2Wrapper codec2Encode = new Codec2Wrapper(0);
    Map<String, Codec2Wrapper> playerDecoders = new ConcurrentHashMap<String, Codec2Wrapper>();
    private long lastSentTime = 0L;
    private int messagesSent = 0;

    public TextVoiceHandler(PlayerAudioMixer mixer, Map<String, PlayerHUDState> hudStates) {
        this.mixer = mixer;
        this.hudStates = hudStates;
    }

    public void startPTT() {
        this.pttActive = true;
        new Thread(this::pttSendLoop, "Voice-PTT-Sender").start();
    }

    public void stopPTT() {
        this.pttActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pttSendLoop() {
        ArrayList<String> outgoing = new ArrayList<String>();
        int currentLen = 0;
        while (this.pttActive || !this.pttSendBuffer.isEmpty()) {
            ArrayList<short[]> framesToSend = new ArrayList<short[]>();
            Iterator iterator = this.pttLock;
            synchronized (iterator) {
                if (!this.pttSendBuffer.isEmpty()) {
                    framesToSend.addAll(this.pttSendBuffer);
                    this.pttSendBuffer.clear();
                }
            }
            for (short[] frame : framesToSend) {
                byte[] codec2Frame = this.codec2Encode.encodeFrame(this.codec2Encode.handle, frame);
                String encoded = SafeBMPCodec.encode(codec2Frame);
                int frameLen = encoded.length() + (outgoing.isEmpty() ? 0 : 1);
                if (currentLen + frameLen > 236) {
                    this.sendBundle(outgoing);
                    outgoing.clear();
                    currentLen = 0;
                    frameLen = encoded.length();
                }
                outgoing.add(encoded);
                currentLen += frameLen;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!outgoing.isEmpty()) {
            this.sendBundle(outgoing);
        }
        this.sendPTTPlaySignal();
    }

    public static List<String> splitEqual(String text, int size) {
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < text.length(); i += size) {
            parts.add(text.substring(i, Math.min(i + size, text.length())));
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onChatMessage(class_2561 message, @Nullable class_7471 signedMessage, @Nullable GameProfile sender, class_2556.class_7602 params, Instant timestamp) {
        class_7417 class_74172 = message.method_10851();
        if (!(class_74172 instanceof class_2588)) {
            return true;
        }
        class_2588 content = (class_2588)class_74172;
        class_7417 textContent = message.method_10851();
        String messageContent = content.method_29434(1).getString();
        String playerName = content.method_29434(0).getString();
        if (messageContent.startsWith(String.valueOf('\ud7f3'))) {
            if (sender == null) {
                return false;
            }
            PlayerReceiveBuffer buffer = this.receiveBuffers.get(sender.getName());
            if (buffer != null) {
                buffer.playOnRelease = true;
                this.playReceiveBuffer(sender.getName(), buffer);
            }
            return false;
        }
        if (!messageContent.startsWith(String.valueOf('\ud7f0')) || !messageContent.endsWith(String.valueOf('\ud7f1'))) {
            return true;
        }
        if (textContent instanceof class_2588) {
            UUID myUUID;
            UUID senderUUID;
            class_2588 translatableTextContent = (class_2588)textContent;
            if (translatableTextContent.method_11022().equals("commands.message.display.outgoing")) {
                return false;
            }
            if (sender != null && (senderUUID = sender.getId()).equals(myUUID = class_310.method_1551().method_53462().getId())) {
                return false;
            }
        }
        try {
            String stripped = messageContent.substring(1, messageContent.length() - 1);
            String[] frames = stripped.split(String.valueOf('\ud7f2'));
            PlayerReceiveBuffer buffer = this.receiveBuffers.computeIfAbsent(playerName, k -> new PlayerReceiveBuffer());
            PlayerHUDState hud = this.hudStates.computeIfAbsent(playerName, k -> new PlayerHUDState());
            hud.lastFrameTime = System.currentTimeMillis();
            for (String frame : frames) {
                if (frame.isEmpty()) continue;
                byte[] codec2Frame = SafeBMPCodec.decode(frame);
                Codec2Wrapper codec2 = this.playerDecoders.computeIfAbsent(playerName, k -> new Codec2Wrapper(0));
                short[] pcm = codec2.decodeFrame(codec2.handle, codec2Frame);
                List<short[]> list = buffer.buffer;
                synchronized (list) {
                    buffer.buffer.add(pcm);
                }
            }
            if (buffer.playOnRelease) {
                this.playReceiveBuffer(playerName, buffer);
            }
        }
        catch (Exception e) {
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"gui.textvoice.errordecode", (Object[])new Object[]{playerName, e}));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferPCM(short[] pcmSamples) {
        List<short[]> list = this.pttSendBuffer;
        synchronized (list) {
            this.pttSendBuffer.add(pcmSamples);
        }
    }

    private void sendPTTPlaySignal() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        String control = "\ud7f3" + (this.targetPlayer != null ? this.targetPlayer : "");
        this.sendChatMessage(control);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playReceiveBuffer(String playerName, PlayerReceiveBuffer buffer) {
        PlayerHUDState hud = this.hudStates.computeIfAbsent(playerName, k -> new PlayerHUDState());
        int totalSamples = buffer.buffer.stream().mapToInt(f -> ((short[])f).length).sum();
        double durationSec = (double)totalSamples / 8000.0;
        hud.playing = true;
        List<short[]> list = buffer.buffer;
        synchronized (list) {
            for (short[] pcm : buffer.buffer) {
                this.mixer.enqueuePlayerFrame(playerName, pcm);
            }
            buffer.buffer.clear();
            buffer.playOnRelease = false;
            new Thread(() -> {
                try {
                    Thread.sleep((long)(durationSec * 1000.0));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                hud.playing = false;
            }).start();
        }
    }

    private void sendBundle(List<String> frames) {
        String bundle = String.join((CharSequence)String.valueOf('\ud7f2'), frames);
        String wrapped = "\ud7f0" + bundle + "\ud7f1";
        this.sendChatMessage(wrapped);
    }

    private void sendChatMessage(String msg) {
        if (this.targetPlayer != null && !this.targetPlayer.isBlank()) {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            long now = System.currentTimeMillis();
            long deltaTime = this.lastSentTime > 0L ? now - this.lastSentTime : 0L;
            this.lastSentTime = now;
            ++this.messagesSent;
            double frequency = deltaTime > 0L ? 1000.0 / (double)deltaTime : 0.0;
            System.out.printf("[textvoice] Sending message #%d: delta=%d ms, freq=%.2f Hz, target=%s, chars=%d%n", this.messagesSent, deltaTime, frequency, this.targetPlayer != null ? this.targetPlayer : "chat", msg.length());
            if (!Objects.equals(this.targetPlayer, "*") && !this.targetPlayer.isBlank()) {
                String whisper = "w " + this.targetPlayer + " " + msg;
                player.field_3944.method_45730(whisper);
            } else {
                player.field_3944.method_45729(msg);
            }
        }
    }

    public void setTargetPlayer(@Nullable String name) {
        this.targetPlayer = name != null && name.length() <= 16 ? name : null;
    }
}

