/*
 * Decompiled with CFR 0.152.
 */
package systems.brn.textvoice.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import systems.brn.textvoice.client.NativeLoader;
import systems.brn.textvoice.client.PlayerAudioMixer;
import systems.brn.textvoice.client.PlayerHUDState;
import systems.brn.textvoice.client.PlayerReceiveBuffer;
import systems.brn.textvoice.client.TextVoiceHandler;
import systems.brn.textvoice.client.audio.Microphone;
import systems.brn.textvoice.client.audio.Speaker;

public class TextVoiceClient
implements ClientModInitializer {
    private Microphone microphone;
    private TextVoiceHandler messageHandler;
    private class_304 pttKey;
    private volatile boolean pttHeld = false;
    public static String MOD_ID = "textvoice";
    public final Map<String, PlayerHUDState> hudStates = new ConcurrentHashMap<String, PlayerHUDState>();
    public final Map<String, PlayerReceiveBuffer> receiveBuffers = new ConcurrentHashMap<String, PlayerReceiveBuffer>();
    private static boolean hudAttached = false;

    public void onInitializeClient() {
        try {
            NativeLoader.loadCodec2();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            this.microphone = new Microphone(8000, 160);
            this.microphone.open(null);
            Speaker speaker = new Speaker(8000);
            speaker.open(null);
            PlayerAudioMixer mixer = new PlayerAudioMixer(speaker, this.hudStates);
            mixer.start();
            this.messageHandler = new TextVoiceHandler(mixer, this.receiveBuffers, this.hudStates);
            class_304.class_11900 TEST_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"textvoice", (String)"main"));
            this.pttKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.textvoice.ptt", class_3675.class_307.field_1668, 296, TEST_CATEGORY));
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
                dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"vcplayer").then(ClientCommandManager.argument((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
                    String targetName = context.getInput().split(" ", 2)[1];
                    this.messageHandler.setTargetPlayer(targetName);
                    class_746 player = class_310.method_1551().field_1724;
                    if (player != null) {
                        player.method_7353((class_2561)class_2561.method_43469((String)"gui.textvoice.targetset", (Object[])new Object[]{targetName}), false);
                    }
                    return 1;
                })));
                dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"vcaudio").then(ClientCommandManager.argument((String)"input", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
                    Mixer.Info[] mixers = AudioSystem.getMixerInfo();
                    Arrays.stream(mixers).filter(m -> AudioSystem.getMixer(m).getTargetLineInfo().length > 0).map(Mixer.Info::getName).forEach(name -> builder.suggest("\"" + name + "\""));
                    return builder.buildFuture();
                }).then(ClientCommandManager.argument((String)"output", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
                    Mixer.Info[] mixers = AudioSystem.getMixerInfo();
                    Arrays.stream(mixers).filter(m -> AudioSystem.getMixer(m).getSourceLineInfo().length > 0).map(Mixer.Info::getName).forEach(name -> builder.suggest("\"" + name + "\""));
                    return builder.buildFuture();
                }).executes(context -> {
                    block3: {
                        String inputDevice = StringArgumentType.getString((CommandContext)context, (String)"input").replaceAll("^\"|\"$", "");
                        String outputDevice = StringArgumentType.getString((CommandContext)context, (String)"output").replaceAll("^\"|\"$", "");
                        Mixer.Info inputMixer = Arrays.stream(AudioSystem.getMixerInfo()).filter(m -> m.getName().equals(inputDevice)).findFirst().orElse(null);
                        Mixer.Info outputMixer = Arrays.stream(AudioSystem.getMixerInfo()).filter(m -> m.getName().equals(outputDevice)).findFirst().orElse(null);
                        class_746 player = class_310.method_1551().field_1724;
                        try {
                            this.microphone.setDevice(inputMixer);
                            speaker.setDevice(outputMixer);
                            if (player != null) {
                                player.method_7353((class_2561)class_2561.method_43469((String)"gui.textvoice.audiodevselected", (Object[])new Object[]{this.microphone.getCurrentMixer().getName(), speaker.getCurrentMixer().getName()}), false);
                            }
                        }
                        catch (LineUnavailableException e) {
                            if (player == null) break block3;
                            player.method_7353((class_2561)class_2561.method_43469((String)"gui.textvoice.audiodevselecterror", (Object[])new Object[]{e.getMessage()}), false);
                        }
                    }
                    return 1;
                }))));
                dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"vcplayerbroadcast").executes(context -> {
                    this.messageHandler.setTargetPlayer("*");
                    class_746 player = class_310.method_1551().field_1724;
                    if (player != null) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"gui.textvoice.targetsetbroadcast"), false);
                    }
                    return 1;
                }));
                dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"vcmaster").then(ClientCommandManager.argument((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> {
                    int volume = IntegerArgumentType.getInteger((CommandContext)context, (String)"volume");
                    mixer.setMasterVolume((short)volume);
                    return 1;
                })));
                dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"vcvolume").then(ClientCommandManager.argument((String)"player", (ArgumentType)class_2186.method_9305()).then(ClientCommandManager.argument((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> {
                    String targetName = context.getInput().split(" ", 5)[1];
                    this.hudStates.computeIfAbsent((String)targetName, (Function<String, PlayerHUDState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onInitializeClient$12(java.lang.String ), (Ljava/lang/String;)Lsystems/brn/textvoice/client/PlayerHUDState;)()).volume = IntegerArgumentType.getInteger((CommandContext)context, (String)"volume");
                    return 1;
                }))));
                if (!hudAttached) {
                    HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.CHAT, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"before_chat"), this::hudRender);
                    hudAttached = true;
                }
            });
            Thread micThread = new Thread(this::micLoop, "textvoice-Mic");
            micThread.setDaemon(true);
            micThread.start();
            Thread keyThread = new Thread(this::keyLoop, "textvoice-PTT-Key");
            keyThread.setDaemon(true);
            keyThread.start();
            ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
                HudElementRegistry.removeElement((class_2960)class_2960.method_60655((String)MOD_ID, (String)"before_chat"));
                this.hudStates.clear();
            });
            ClientReceiveMessageEvents.ALLOW_CHAT.register(this.messageHandler::onChatMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hudRender(class_332 drawContext, class_9779 renderTickCounter) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        int x = 5;
        int[] y = new int[]{5};
        long now = System.currentTimeMillis();
        long activeThreshold = 2000L;
        long displayThreshold = 60000L;
        this.hudStates.forEach((playerName, state) -> {
            if (now - state.lastFrameTime > displayThreshold && state.playingTo <= System.currentTimeMillis()) {
                return;
            }
            int baseColor = now - state.lastFrameTime < 100L ? -65536 : (state.playingTo > System.currentTimeMillis() ? -16711936 : -1996488705);
            int width = 160;
            int height = 12;
            drawContext.method_25294(x, y[0], x + width, y[0] + height, baseColor);
            PlayerReceiveBuffer buffer = this.receiveBuffers.getOrDefault(playerName, new PlayerReceiveBuffer());
            int totalSamples = buffer.buffer.stream().mapToInt(f -> ((short[])f).length).sum();
            double timePlaying = (double)(state.playingTo - System.currentTimeMillis()) / 1000.0;
            timePlaying = Math.max(timePlaying, 0.0);
            double timeBuffered = (double)totalSamples / 8000.0;
            timeBuffered = Math.max(timeBuffered, 0.0);
            drawContext.method_51433(client.field_1772, playerName + " " + state.volume + "% " + timePlaying + " (" + timeBuffered + ")", x + 2, y[0] + 1, -1, false);
            float frameDelta = Math.min(1.0f, (float)(now - state.lastFrameTime) / (float)activeThreshold);
            int frameWidth = (int)((1.0f - frameDelta) * (float)(width - 4));
            drawContext.method_25294(x + 2, y[0] + height - 4, x + 2 + frameWidth, y[0] + height - 2, -65536);
            y[0] = y[0] + (height + 4);
        });
    }

    void micLoop() {
        while (true) {
            try {
                while (true) {
                    short[] pcm = this.microphone.readFrame();
                    if (this.pttHeld && pcm.length > 0) {
                        this.messageHandler.bufferPCM(pcm);
                    }
                    Thread.sleep(20L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    void keyLoop() {
        while (true) {
            boolean pressed;
            if ((pressed = this.pttKey.method_1434()) != this.pttHeld) {
                this.pttHeld = pressed;
                if (this.pttHeld) {
                    class_746 player = class_310.method_1551().field_1724;
                    if (this.messageHandler.targetPlayer == null || this.messageHandler.targetPlayer.isBlank()) {
                        if (player != null) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"gui.textvoice.notarget"), true);
                        }
                    } else if (player != null) {
                        player.method_7353((class_2561)class_2561.method_43469((String)"gui.textvoice.targettx", (Object[])new Object[]{this.messageHandler.targetPlayer}), true);
                    }
                    this.messageHandler.startPTT();
                } else {
                    this.messageHandler.stopPTT();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private static /* synthetic */ PlayerHUDState lambda$onInitializeClient$12(String k) {
        return new PlayerHUDState();
    }
}

