/*
 * Decompiled with CFR 0.152.
 */
package systems.brn.textvoice.client;

import java.util.Arrays;

public class Base96 {
    private static final char[] CHARSET = Base96.buildCharset();
    private static final int BASE = CHARSET.length;
    private static final int[] REVERSE = new int[128];

    private static char[] buildCharset() {
        StringBuilder sb = new StringBuilder();
        for (int i = 32; i < 128; ++i) {
            if (i == 167) continue;
            sb.append((char)i);
        }
        return sb.toString().toCharArray();
    }

    public static String encode(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            int v = b & 0xFF;
            int high = v / BASE;
            int low = v % BASE;
            sb.append(CHARSET[high]).append(CHARSET[low]);
        }
        return sb.toString();
    }

    public static byte[] decode(String str) {
        if (str.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid Base96 string length");
        }
        byte[] data = new byte[str.length() / 2];
        for (int i = 0; i < data.length; ++i) {
            int high = REVERSE[str.charAt(i * 2)];
            int low = REVERSE[str.charAt(i * 2 + 1)];
            if (high == -1 || low == -1) {
                throw new IllegalArgumentException("Invalid Base96 char");
            }
            data[i] = (byte)(high * BASE + low);
        }
        return data;
    }

    public static void main(String[] args) {
        byte[] original = "Hello, Minecraft-safe Base96!".getBytes();
        String encoded = Base96.encode(original);
        byte[] decoded = Base96.decode(encoded);
        System.out.println("Original: " + new String(original));
        System.out.println("Encoded: " + encoded);
        System.out.println("Decoded: " + new String(decoded));
    }

    static {
        Arrays.fill(REVERSE, -1);
        for (int i = 0; i < CHARSET.length; ++i) {
            Base96.REVERSE[Base96.CHARSET[i]] = i;
        }
    }
}

