/*
 * Decompiled with CFR 0.152.
 */
package systems.brn.textvoice.client;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import systems.brn.textvoice.client.audio.Speaker;

public class PlayerAudioMixer {
    private final Speaker speaker;
    private final Map<String, Queue<short[]>> streams = new ConcurrentHashMap<String, Queue<short[]>>();
    private final int frameSamples = 160;
    private final int sampleRate = 8000;

    public PlayerAudioMixer(Speaker speaker) {
        this.speaker = speaker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueuePlayerFrame(String playerName, short[] pcm) {
        Queue queue;
        Queue queue2 = queue = this.streams.computeIfAbsent(playerName, k -> new LinkedList());
        synchronized (queue2) {
            queue.add(pcm);
        }
    }

    public void start() {
        Thread thread = new Thread(() -> {
            short[] mixBuffer = new short[160];
            long nextFrameTime = System.nanoTime();
            while (true) {
                Arrays.fill(mixBuffer, (short)0);
                for (Queue<short[]> queue : this.streams.values()) {
                    short[] frame = null;
                    Queue<short[]> queue2 = queue;
                    synchronized (queue2) {
                        if (!queue.isEmpty()) {
                            frame = queue.poll();
                        }
                    }
                    if (frame == null) continue;
                    for (int i = 0; i < Math.min(frame.length, mixBuffer.length); ++i) {
                        int mixed = mixBuffer[i] + frame[i];
                        if (mixed > Short.MAX_VALUE) {
                            mixed = Short.MAX_VALUE;
                        }
                        if (mixed < Short.MIN_VALUE) {
                            mixed = Short.MIN_VALUE;
                        }
                        mixBuffer[i] = (short)mixed;
                    }
                }
                this.speaker.play(mixBuffer);
                long sleepTime = ((nextFrameTime += 20000000L) - System.nanoTime()) / 1000000L;
                if (sleepTime <= 0L) continue;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }, "textvoice-Mixer");
        thread.setDaemon(true);
        thread.start();
    }
}

