/*
 * Decompiled with CFR 0.152.
 */
package systems.brn.textvoice.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class SafeBMPCodec {
    private static final int[] SAFE_RANGES;
    private static final char[] SAFE_CHARS;
    private static final int BASE;

    public static String encode(byte[] data) {
        StringBuilder sb = new StringBuilder();
        int N = SAFE_CHARS.length;
        for (int i = 0; i < data.length; i += 2) {
            int high = data[i] & 0xFF;
            int low = i + 1 < data.length ? data[i + 1] & 0xFF : 0;
            int value16 = high << 8 | low;
            int digit1 = value16 / N;
            int digit2 = value16 % N;
            sb.append(SAFE_CHARS[digit1]);
            sb.append(SAFE_CHARS[digit2]);
        }
        return sb.toString();
    }

    public static byte[] decode(String s) {
        int N = SAFE_CHARS.length;
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (int i = 0; i < s.length(); i += 2) {
            int digit1 = SafeBMPCodec.charToIndex(s.charAt(i));
            int digit2 = SafeBMPCodec.charToIndex(s.charAt(i + 1));
            int value16 = digit1 * N + digit2;
            bytes.add((byte)(value16 >> 8 & 0xFF));
            bytes.add((byte)(value16 & 0xFF));
        }
        byte[] out = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            out[i] = (Byte)bytes.get(i);
        }
        return out;
    }

    private static int charToIndex(char c) {
        int low = 0;
        int high = SAFE_CHARS.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (SAFE_CHARS[mid] < c) {
                low = mid + 1;
                continue;
            }
            if (SAFE_CHARS[mid] > c) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        throw new IllegalArgumentException(String.format("Invalid safe char: U+%04X", c));
    }

    public static void main(String[] args) {
        byte[] codec2Audio = new byte[320];
        new Random(12345L).nextBytes(codec2Audio);
        System.out.println("Original bytes:");
        System.out.println(Arrays.toString(Arrays.copyOf(codec2Audio, 16)) + " ...");
        String encoded = SafeBMPCodec.encode(codec2Audio);
        System.out.println("Encoded length: " + encoded.length());
        System.out.println("First 16 chars: " + encoded.substring(0, Math.min(16, encoded.length())) + " ...");
        byte[] decoded = SafeBMPCodec.decode(encoded);
        System.out.println("Decoded bytes:");
        System.out.println(Arrays.toString(Arrays.copyOf(decoded, 16)) + " ...");
        if (Arrays.equals(codec2Audio, decoded)) {
            System.out.println("\u2705 Test passed: decoded bytes match original!");
        } else {
            System.out.println("\u274c Test failed: decoded bytes differ!");
            for (int i = 0; i < codec2Audio.length; ++i) {
                if (codec2Audio[i] == decoded[i]) continue;
                System.out.printf("Difference at byte %d: original=%02X decoded=%02X%n", i, codec2Audio[i], decoded[i]);
                break;
            }
        }
    }

    static {
        int i;
        SAFE_RANGES = new int[]{32, 166, 168, 55280};
        ArrayList<Character> temp = new ArrayList<Character>();
        for (i = 0; i < SAFE_RANGES.length; i += 2) {
            for (int cp = SAFE_RANGES[i]; cp <= SAFE_RANGES[i + 1]; ++cp) {
                temp.add(Character.valueOf((char)cp));
            }
        }
        SAFE_CHARS = new char[temp.size()];
        for (i = 0; i < temp.size(); ++i) {
            SafeBMPCodec.SAFE_CHARS[i] = ((Character)temp.get(i)).charValue();
        }
        BASE = SAFE_CHARS.length;
    }
}

