/*
 * Decompiled with CFR 0.152.
 */
package systems.brn.textvoice.client.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class Microphone {
    private final int sampleRate;
    private final int frameSize;
    private TargetDataLine line;

    public Microphone(int sampleRate, int frameSize) {
        this.sampleRate = sampleRate;
        this.frameSize = frameSize;
    }

    public void open() throws LineUnavailableException {
        AudioFormat format = new AudioFormat(this.sampleRate, 16, 1, true, false);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        this.line = (TargetDataLine)AudioSystem.getLine(info);
        this.line.open(format, this.frameSize * 2);
    }

    public void start() {
        if (this.line != null) {
            this.line.start();
        }
    }

    public short[] readFrame() {
        byte[] buffer = new byte[this.frameSize * 2];
        int bytesRead = this.line.read(buffer, 0, buffer.length);
        short[] pcm = new short[bytesRead / 2];
        for (int i = 0; i < pcm.length; ++i) {
            int lo = buffer[i * 2] & 0xFF;
            int hi = buffer[i * 2 + 1] << 8;
            pcm[i] = (short)(hi | lo);
        }
        return pcm;
    }

    public void close() {
        if (this.line != null) {
            this.line.stop();
            this.line.close();
        }
    }
}

