/*
 * Decompiled with CFR 0.152.
 */
package net.txsla.advancedrestart;

import net.txsla.advancedrestart.Metrics;
import net.txsla.advancedrestart.command.main_command;
import net.txsla.advancedrestart.config;
import net.txsla.advancedrestart.threads.inactive_restart;
import net.txsla.advancedrestart.threads.periodic_restart;
import net.txsla.advancedrestart.threads.ram_restart;
import net.txsla.advancedrestart.threads.schedule_restart;
import net.txsla.advancedrestart.threads.tps_restart;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class AdvancedRestart
extends JavaPlugin {
    static Plugin plugin;

    public void onEnable() {
        this.saveDefaultConfig();
        plugin = AdvancedRestart.getPlugin(((Object)((Object)this)).getClass());
        int pluginId = 21811;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        this.getLogger().info("Loading configs...");
        config.plugin = this;
        if (config.load()) {
            this.getLogger().info("Config load complete!");
        } else {
            this.getLogger().warning("PLUGIN FAILED TO PROPERLY LOAD CONFIGS - CHECK /plugins/AdvancedRestart/config.yml FOR MISTAKES!");
        }
        if (config.debug) {
            Bukkit.getServer().getConsoleSender().sendMessage("[AdvancedRestart] \u00a74Debug Mode Enabled");
        }
        this.getLogger().info("Starting threads...");
        if (this.start()) {
            this.getLogger().info("Threads started!");
        } else {
            this.getLogger().warning("PLUGIN FAILED TO PROPERLY LOAD THREADS - CHECK /plugins/AdvancedRestart/config.yml FOR MISTAKES!");
        }
        this.getCommand("advancedrestart").setExecutor((CommandExecutor)new main_command());
    }

    public boolean start() {
        try {
            if (config.inactiveRestart_enabled) {
                this.getLogger().info("inactiveRestart Enabled");
                this.getServer().getPluginManager().registerEvents((Listener)new inactive_restart(), (Plugin)this);
            }
            if (config.periodicRestart_enabled) {
                this.getLogger().info("periodicRestart Enabled");
                new periodic_restart();
            }
            if (config.lagRestart_lowTPS_enabled) {
                this.getLogger().info("tpsRestart Enabled");
                new tps_restart();
            }
            if (config.lagRestart_lowMemory_enabled) {
                this.getLogger().info("ramRestart Enabled");
                new ram_restart();
            }
            if (config.scheduledRestart_enabled) {
                this.getLogger().info("scheduledRestart Enabled");
                new schedule_restart();
            }
        }
        catch (Exception e) {
            this.getLogger().warning("[Advanced Restart] Failed to start threads\n" + e + "\n\n");
            return false;
        }
        return true;
    }

    public boolean stop() {
        return false;
    }

    public void onDisable() {
        this.getLogger().info("plugin disabled");
    }

    public static void executeCommand(String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        if (config.debug) {
            System.out.println("[Advanced Restart] executing command " + command);
        }
        if (Bukkit.isPrimaryThread()) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        } else {
            String com = command;
            Bukkit.getScheduler().runTask(plugin, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)com));
        }
    }
}

