/*
 * Decompiled with CFR 0.152.
 */
package net.txsla.advancedrestart.threads;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.txsla.advancedrestart.config;
import net.txsla.advancedrestart.format;
import net.txsla.advancedrestart.threads.stop_server;
import org.bukkit.Bukkit;

public class schedule_restart {
    Thread dailyRestart;
    public static String[][] schedule;

    private static String getTime() {
        return DateTimeFormatter.ofPattern("HH:mm").format(LocalDateTime.now());
    }

    private static String getDay() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("E")).toUpperCase();
    }

    public schedule_restart() {
        Bukkit.getServer().getConsoleSender().sendMessage("[AdvancedRestart] \u00a74SYNC \u00a7cServer day/time: " + schedule_restart.getDay() + " " + schedule_restart.getTime());
        this.parseSchedule();
        this.scheduleManager();
    }

    private void scheduleManager() {
        if (config.debug) {
            for (int i = 0; schedule.length > i; ++i) {
                try {
                    Bukkit.getServer().getConsoleSender().sendMessage("[dailyRestart.scheduleManager] schedule list [" + i + "] :" + schedule[i][0] + " " + schedule[i][1]);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        this.dailyRestart = new Thread(() -> {
            boolean restart = false;
            block2: while (!restart) {
                try {
                    Thread.sleep(15000L);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
                for (String[] strings : schedule) {
                    if (strings[0] == null) continue;
                    if (strings[0].matches(schedule_restart.getDay() + "|ALL") && strings[1].matches(schedule_restart.getTime())) {
                        restart = true;
                        continue block2;
                    }
                    if (!config.debug) continue;
                    Bukkit.getServer().getConsoleSender().sendMessage("[dailyRestart.scheduleManager.thread] checking time: " + strings[0] + " " + strings[1]);
                }
            }
            this.stopServer();
        });
        this.dailyRestart.start();
    }

    private void parseSchedule() {
        List<String> uf = config.scheduledRestart_schedule;
        schedule = new String[uf.size()][2];
        for (int i = 0; i < uf.size(); ++i) {
            if (uf.get(i).matches("^[A-Za-z]{3}-[0-2][0-9]:[0-5][0-9]$")) {
                schedule_restart.schedule[i][0] = uf.get(i).toUpperCase().replaceAll("-.*", "");
                schedule_restart.schedule[i][1] = uf.get(i).toUpperCase().replaceAll("^[^-]*-", "");
                continue;
            }
            System.out.println("[Advanced Restart] Error parsing " + uf.get(i) + ". Check Schedule format in config");
        }
    }

    private void stopServer() {
        block15: {
            block14: {
                block13: {
                    if (config.debug) {
                        System.out.println("[dailyRestart.scheduleManager] server stopping;");
                    }
                    try {
                        format.sendMessage(config.scheduledRestart_message);
                    }
                    catch (Exception e) {
                        if (!config.debug) break block13;
                        System.out.println(e);
                    }
                }
                if (config.restartWarning_minuteWarn_enabled) {
                    if (config.restartWarning_minuteWarn_countdown) {
                        stop_server.send_message_and_sleep_recursively(60000, config.restartWarning_minuteWarn_minutes, config.restartWarning_minuteWarn_message);
                    } else {
                        try {
                            stop_server.send_message_and_sleep(config.restartWarning_minuteWarn_minutes * 60000, config.restartWarning_minuteWarn_message.replaceAll("%M", "" + config.restartWarning_minuteWarn_minutes));
                        }
                        catch (Exception e) {
                            if (!config.debug) break block14;
                            System.out.println(e);
                        }
                    }
                }
            }
            if (config.restartWarning_secondsWarn_enabled) {
                if (config.restartWarning_secondsWarn_countdown) {
                    stop_server.send_message_and_sleep_recursively(1000, config.restartWarning_secondsWarn_seconds, config.restartWarning_secondsWarn_message);
                } else {
                    try {
                        stop_server.send_message_and_sleep(config.restartWarning_secondsWarn_seconds * 1000, config.restartWarning_secondsWarn_message.replaceAll("%S", "" + config.restartWarning_secondsWarn_seconds));
                    }
                    catch (Exception e) {
                        if (!config.debug) break block15;
                        System.out.println(e);
                    }
                }
            }
        }
        stop_server.shutdown();
    }
}

