/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.mixin;

import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.ModelPartInjector;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.api.OffsetProvider;
import dev.tr7zw.transition.mc.entitywrapper.EntityRenderStateExtender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public class PlayerModelMixin<T extends LivingEntity>
extends HumanoidModel
implements PlayerEntityModelAccessor {
    @Shadow
    public ModelPart leftSleeve;
    @Shadow
    public ModelPart rightSleeve;
    @Shadow
    public ModelPart leftPants;
    @Shadow
    public ModelPart rightPants;
    @Shadow
    public ModelPart jacket;
    @Shadow
    private boolean slim;

    public PlayerModelMixin(ModelPart modelPart) {
        super(modelPart);
    }

    @Override
    public boolean hasThinArms() {
        return this.slim;
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V"}, at={@At(value="TAIL")}, cancellable=true)
    public void setupAnim(PlayerRenderState playerRenderState, CallbackInfo ci) {
        AbstractClientPlayer entity;
        EntityRenderStateExtender extender;
        Entity entity2;
        AbstractClientPlayer abstractClientPlayer = null;
        if (!(playerRenderState instanceof EntityRenderStateExtender) || !((entity2 = (extender = (EntityRenderStateExtender)playerRenderState).getTransitionEntity()) instanceof AbstractClientPlayer)) {
            return;
        }
        abstractClientPlayer = entity = (AbstractClientPlayer)entity2;
        PlayerSettings settings = (PlayerSettings)abstractClientPlayer;
        ((ModelPartInjector)this.hat).setInjectedMesh(null, null);
        ((ModelPartInjector)this.jacket).setInjectedMesh(null, null);
        ((ModelPartInjector)this.leftSleeve).setInjectedMesh(null, null);
        ((ModelPartInjector)this.rightSleeve).setInjectedMesh(null, null);
        ((ModelPartInjector)this.leftPants).setInjectedMesh(null, null);
        ((ModelPartInjector)this.rightPants).setInjectedMesh(null, null);
        if (Minecraft.getInstance().player == null || abstractClientPlayer.distanceToSqr(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition()) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        if (!SkinUtil.setup3dLayers(abstractClientPlayer, settings, this.slim)) {
            return;
        }
        ItemStack itemStack = abstractClientPlayer.getItemBySlot(EquipmentSlot.HEAD);
        if (SkinLayersModBase.config.enableHat && (itemStack == null || !SkinLayersModBase.hideHeadLayers.contains(itemStack.getItem()))) {
            ((ModelPartInjector)this.hat).setInjectedMesh(settings.getHeadMesh(), OffsetProvider.HEAD);
        }
        if (SkinLayersModBase.config.enableJacket) {
            ((ModelPartInjector)this.jacket).setInjectedMesh(settings.getTorsoMesh(), OffsetProvider.BODY);
        }
        if (SkinLayersModBase.config.enableLeftSleeve) {
            ((ModelPartInjector)this.leftSleeve).setInjectedMesh(settings.getLeftArmMesh(), this.slim ? OffsetProvider.LEFT_ARM_SLIM : OffsetProvider.LEFT_ARM);
        }
        if (SkinLayersModBase.config.enableRightSleeve) {
            ((ModelPartInjector)this.rightSleeve).setInjectedMesh(settings.getRightArmMesh(), this.slim ? OffsetProvider.RIGHT_ARM_SLIM : OffsetProvider.RIGHT_ARM);
        }
        if (SkinLayersModBase.config.enableLeftPants) {
            ((ModelPartInjector)this.leftPants).setInjectedMesh(settings.getLeftLegMesh(), OffsetProvider.LEFT_LEG);
        }
        if (SkinLayersModBase.config.enableRightPants) {
            ((ModelPartInjector)this.rightPants).setInjectedMesh(settings.getRightLegMesh(), OffsetProvider.RIGHT_LEG);
        }
    }
}

