/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.google.common.collect.Lists;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.versionless.render.CustomizableCube;
import dev.tr7zw.skinlayers.versionless.util.Direction;
import dev.tr7zw.skinlayers.versionless.util.wrapper.ModelBuilder;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDefinition;
import net.minecraft.client.model.geom.builders.CubeListBuilder;

public class CustomizableCubeListBuilder
implements ModelBuilder {
    private final List<CustomizableCube> cubes = Lists.newArrayList();
    private final List<ModelPart.Cube> vanillaCubes = Lists.newArrayList();
    private int u;
    private int v;
    private boolean mirror;
    private int textureWidth = 64;
    private int textureHeight = 64;

    public static ModelBuilder create() {
        return new CustomizableCubeListBuilder();
    }

    @Override
    public ModelBuilder textureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
        return this;
    }

    @Override
    public ModelBuilder uv(int u, int v) {
        this.u = u;
        this.v = v;
        return this;
    }

    @Override
    public ModelBuilder mirror(boolean bl) {
        this.mirror = bl;
        return this;
    }

    public List<CustomizableCube> getCubes() {
        return this.cubes;
    }

    public List<ModelPart.Cube> getVanillaCubes() {
        return this.vanillaCubes;
    }

    @Override
    public ModelBuilder addBox(float x, float y, float z, float pixelSize, Direction[] hide, Direction[][] corners) {
        if (!SkinLayersModBase.config.irisCompatibilityMode) {
            this.cubes.add(new CustomizableCube(this.u, this.v, (float)(this.mirror ? -1 : 1) * x, y, z, pixelSize, pixelSize, pixelSize, 0.0f, 0.0f, 0.0f, this.mirror, this.textureWidth, this.textureHeight, hide, corners));
        } else {
            this.cubes.add(new CustomizableCube(this.u, this.v, (float)(this.mirror ? -1 : 1) * x, y, z, pixelSize, pixelSize, pixelSize, 0.0f, 0.0f, 0.0f, this.mirror, this.textureWidth, this.textureHeight, hide, corners));
        }
        return this;
    }

    @Override
    public ModelBuilder addVanillaBox(float x, float y, float z, float width, float height, float depth) {
        if (this.mirror) {
            x = -1.0f;
        }
        CubeListBuilder cubeList = CubeListBuilder.m_171558_();
        cubeList.m_171514_(this.u, this.v).m_171555_(this.mirror).m_171481_(x, y, z, width, height, depth);
        this.vanillaCubes.add(((CubeDefinition)cubeList.m_171557_().get(0)).m_171455_(this.textureWidth, this.textureHeight));
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.getCubes().isEmpty() && this.getVanillaCubes().isEmpty();
    }
}

