/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.mojang.authlib.GameProfile;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.accessor.HttpTextureAccessor;
import dev.tr7zw.skinlayers.accessor.NativeImageAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.accessor.SkullSettings;
import dev.tr7zw.skinlayers.api.SkinLayersAPI;
import dev.tr7zw.transition.mc.PlayerUtil;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_742;

public class SkinUtil {
    static Cache<class_1044, class_1011> cache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<class_1044, class_1011>(){

        public void onRemoval(RemovalNotification<class_1044, class_1011> notification) {
            try {
                ((class_1011)notification.getValue()).close();
            }
            catch (Exception ex) {
                SkinLayersModBase.LOGGER.error("Error while closing a texture.", (Throwable)ex);
            }
        }
    }).build();

    public static class_1011 getTexture(class_2960 resourceLocation, SkullSettings settings) {
        if (resourceLocation == null) {
            return null;
        }
        try {
            NativeImageAccessor ac;
            class_1011 class_10112;
            if (class_310.method_1551().method_1478().method_18234(resourceLocation)) {
                class_3298 resource = class_310.method_1551().method_1478().method_14486(resourceLocation);
                class_1011 skin = class_1011.method_4309((InputStream)resource.method_14482());
                return skin;
            }
            class_1044 texture = class_310.method_1551().method_1531().method_4619(resourceLocation);
            if (texture == null) {
                return null;
            }
            class_1011 cachedImage = (class_1011)cache.getIfPresent((Object)texture);
            if (cachedImage != null && (class_10112 = cachedImage) instanceof NativeImageAccessor && (ac = (NativeImageAccessor)class_10112).skinlayers$isAllocated()) {
                return cachedImage;
            }
            cache.invalidate((Object)texture);
            if (texture instanceof HttpTextureAccessor) {
                HttpTextureAccessor httpTexture = (HttpTextureAccessor)texture;
                try {
                    NativeImageAccessor ac2;
                    class_1011 class_10113;
                    class_1011 img = httpTexture.getImage();
                    if (img != null && (class_10113 = img) instanceof NativeImageAccessor && (ac2 = (NativeImageAccessor)class_10113).skinlayers$isAllocated()) {
                        cache.put((Object)texture, (Object)img);
                        return img;
                    }
                }
                catch (Exception img) {
                    // empty catch block
                }
                return null;
            }
            if (texture instanceof class_1043) {
                try {
                    NativeImageAccessor ac3;
                    class_1011 class_10114;
                    class_1011 img = ((class_1043)texture).method_4525();
                    if (img != null && (class_10114 = img) instanceof NativeImageAccessor && (ac3 = (NativeImageAccessor)class_10114).skinlayers$isAllocated()) {
                        return img;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            if (settings != null) {
                settings.setInitialized(false);
            }
            String string = texture.getClass().getName();
            String string2 = String.valueOf(resourceLocation);
            SkinLayersModBase.LOGGER.warn("Unable to handle skin " + string2 + ". Potentially a conflict with another mod. (" + string + ")");
            return null;
        }
        catch (Exception ex) {
            SkinLayersModBase.LOGGER.error("Error while resolving a skin texture.", (Throwable)ex);
            return null;
        }
    }

    public static boolean setup3dLayers(class_742 abstractClientPlayerEntity, PlayerSettings settings, boolean thinArms) {
        class_2960 skinLocation = PlayerUtil.getPlayerSkin((class_742)abstractClientPlayerEntity);
        if (skinLocation == null) {
            return false;
        }
        if (skinLocation.equals((Object)settings.getCurrentSkin()) && thinArms == settings.hasThinArms()) {
            return settings.getHeadMesh() != null;
        }
        class_1011 skin = SkinUtil.getTexture(skinLocation, null);
        if (skin == null || skin.method_4307() != 64 || skin.method_4323() != 64) {
            settings.setCurrentSkin(skinLocation);
            settings.setThinArms(thinArms);
            settings.clearMeshes();
            return false;
        }
        settings.setLeftLegMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 4, 12, 4, 0, 48, true, 0.0f));
        settings.setRightLegMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 4, 12, 4, 0, 32, true, 0.0f));
        if (thinArms) {
            settings.setLeftArmMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 3, 12, 4, 48, 48, true, -2.0f));
            settings.setRightArmMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 3, 12, 4, 40, 32, true, -2.0f));
        } else {
            settings.setLeftArmMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 4, 12, 4, 48, 48, true, -2.0f));
            settings.setRightArmMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 4, 12, 4, 40, 32, true, -2.0f));
        }
        settings.setTorsoMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 8, 12, 4, 16, 32, true, 0.0f));
        settings.setHeadMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 8, 8, 8, 32, 0, false, 0.6f));
        settings.setCurrentSkin(skinLocation);
        settings.setThinArms(thinArms);
        return true;
    }

    public static boolean setup3dLayers(GameProfile gameprofile, SkullSettings settings) {
        if (gameprofile == null) {
            return false;
        }
        class_2960 playerSkin = PlayerUtil.getPlayerSkin((GameProfile)gameprofile);
        if (playerSkin == null) {
            return false;
        }
        class_1011 skin = SkinUtil.getTexture(playerSkin, settings);
        if (skin == null || skin.method_4307() != 64 || skin.method_4323() != 64) {
            return false;
        }
        settings.setupHeadLayers(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 8, 8, 8, 32, 0, false, 0.6f));
        settings.setInitialized(true);
        return true;
    }

    public static boolean setup3dLayers(class_2960 playerSkin, SkullSettings settings) {
        if (playerSkin == null) {
            return false;
        }
        class_1011 skin = SkinUtil.getTexture(playerSkin, settings);
        if (skin == null || skin.method_4307() != 64 || skin.method_4323() != 64) {
            return false;
        }
        settings.setupHeadLayers(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 8, 8, 8, 32, 0, false, 0.6f));
        settings.setInitialized(true);
        return true;
    }
}

