/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.api;

import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.Shape;
import net.minecraft.class_4587;

public interface OffsetProvider {
    public static final OffsetProvider SKULL = OffsetProvider.createVanilla(Shape.HEAD, false, false, true);
    public static final OffsetProvider HEAD = OffsetProvider.createVanilla(Shape.HEAD);
    public static final OffsetProvider LEFT_LEG = OffsetProvider.createVanilla(Shape.LEGS);
    public static final OffsetProvider RIGHT_LEG = OffsetProvider.createVanilla(Shape.LEGS);
    public static final OffsetProvider LEFT_ARM = OffsetProvider.createVanilla(Shape.ARMS);
    public static final OffsetProvider LEFT_ARM_SLIM = OffsetProvider.createVanilla(Shape.ARMS_SLIM);
    public static final OffsetProvider RIGHT_ARM = OffsetProvider.createVanilla(Shape.ARMS, true, false, false);
    public static final OffsetProvider RIGHT_ARM_SLIM = OffsetProvider.createVanilla(Shape.ARMS_SLIM, true, false, false);
    public static final OffsetProvider FIRSTPERSON_LEFT_ARM = OffsetProvider.createVanilla(Shape.ARMS, false, true, false);
    public static final OffsetProvider FIRSTPERSON_LEFT_ARM_SLIM = OffsetProvider.createVanilla(Shape.ARMS_SLIM, false, true, false);
    public static final OffsetProvider FIRSTPERSON_RIGHT_ARM = OffsetProvider.createVanilla(Shape.ARMS, true, true, false);
    public static final OffsetProvider FIRSTPERSON_RIGHT_ARM_SLIM = OffsetProvider.createVanilla(Shape.ARMS_SLIM, true, true, false);
    public static final OffsetProvider BODY = OffsetProvider.createVanilla(Shape.BODY);

    public void applyOffset(class_4587 var1, Mesh var2);

    public static OffsetProvider createVanilla(Shape shape) {
        return OffsetProvider.createVanilla(shape, false, false, false);
    }

    public static OffsetProvider createVanilla(Shape shape, boolean mirrored, boolean firstperson, boolean skull) {
        return (stack, mesh) -> {
            float pixelScaling = SkinLayersModBase.config.baseVoxelSize;
            float heightScaling = 1.035f;
            float widthScaling = SkinLayersModBase.config.baseVoxelSize;
            if (firstperson) {
                pixelScaling = SkinLayersModBase.config.firstPersonPixelScaling;
                widthScaling = SkinLayersModBase.config.firstPersonPixelScaling;
            }
            float x = 0.0f;
            float y = 0.0f;
            if (shape == Shape.ARMS) {
                x = 0.998f;
            } else if (shape == Shape.ARMS_SLIM) {
                x = 0.499f;
            }
            if (shape == Shape.BODY) {
                widthScaling = SkinLayersModBase.config.bodyVoxelWidthSize;
            }
            if (mirrored) {
                x *= -1.0f;
            }
            if (shape == Shape.HEAD) {
                float voxelSize = SkinLayersModBase.config.headVoxelSize;
                if (skull) {
                    voxelSize = SkinLayersModBase.config.skullVoxelSize;
                }
                stack.method_22904(0.0, -0.25, 0.0);
                stack.method_22905(voxelSize, voxelSize, voxelSize);
                stack.method_22904(0.0, 0.25, 0.0);
                stack.method_22904(0.0, -0.04, 0.0);
            } else {
                stack.method_22905(widthScaling, heightScaling, pixelScaling);
                y = shape.yOffsetMagicValue();
            }
            mesh.setPosition(x, y, 0.0f);
        };
    }
}

