/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.google.common.collect.Lists;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.versionless.render.CustomizableCube;
import dev.tr7zw.skinlayers.versionless.util.Direction;
import dev.tr7zw.skinlayers.versionless.util.wrapper.ModelBuilder;
import java.util.List;
import net.minecraft.class_5604;
import net.minecraft.class_5606;
import net.minecraft.class_630;

public class CustomizableCubeListBuilder
implements ModelBuilder {
    private final List<CustomizableCube> cubes = Lists.newArrayList();
    private final List<class_630.class_628> vanillaCubes = Lists.newArrayList();
    private int u;
    private int v;
    private boolean mirror;
    private int textureWidth = 64;
    private int textureHeight = 64;

    public static ModelBuilder create() {
        return new CustomizableCubeListBuilder();
    }

    @Override
    public ModelBuilder textureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
        return this;
    }

    @Override
    public ModelBuilder uv(int u, int v) {
        this.u = u;
        this.v = v;
        return this;
    }

    @Override
    public ModelBuilder mirror(boolean bl) {
        this.mirror = bl;
        return this;
    }

    public List<CustomizableCube> getCubes() {
        return this.cubes;
    }

    public List<class_630.class_628> getVanillaCubes() {
        return this.vanillaCubes;
    }

    @Override
    public ModelBuilder addBox(float x, float y, float z, float pixelSize, Direction[] hide, Direction[][] corners) {
        if (!SkinLayersModBase.config.irisCompatibilityMode) {
            this.cubes.add(new CustomizableCube(this.u, this.v, (float)(this.mirror ? -1 : 1) * x, y, z, pixelSize, pixelSize, pixelSize, 0.0f, 0.0f, 0.0f, this.mirror, this.textureWidth, this.textureHeight, hide, corners));
        } else {
            this.cubes.add(new CustomizableCube(this.u, this.v, (float)(this.mirror ? -1 : 1) * x, y, z, pixelSize, pixelSize, pixelSize, 0.0f, 0.0f, 0.0f, this.mirror, this.textureWidth, this.textureHeight, hide, corners));
        }
        return this;
    }

    @Override
    public ModelBuilder addVanillaBox(float x, float y, float z, float width, float height, float depth) {
        if (this.mirror) {
            x = -1.0f;
        }
        class_5606 cubeList = class_5606.method_32108();
        cubeList.method_32101(this.u, this.v).method_32106(this.mirror).method_32097(x, y, z, width, height, depth);
        this.vanillaCubes.add(((class_5604)cubeList.method_32107().get(0)).method_32093(this.textureWidth, this.textureHeight));
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.getCubes().isEmpty() && this.getVanillaCubes().isEmpty();
    }
}

