/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.skinlayers.accessor.ModelPartInjector;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.OffsetProvider;
import dev.tr7zw.skinlayers.util.SodiumWorkaround;
import java.util.Map;
import lombok.Generated;
import net.minecraft.client.model.geom.ModelPart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.class}, priority=300)
public class ModelPartMixin
implements ModelPartInjector {
    @Shadow
    boolean visible;
    @Shadow
    private Map<String, ModelPart> children;
    private Mesh injectedMesh = null;
    private OffsetProvider offsetProvider = null;

    @Inject(method={"Lnet/minecraft/client/model/geom/ModelPart;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha, CallbackInfo ci) {
        if (this.visible && this.injectedMesh != null) {
            poseStack.pushPose();
            this.translateAndRotate(poseStack);
            this.offsetProvider.applyOffset(poseStack, this.injectedMesh);
            this.injectedMesh.render((ModelPart)this, poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
            poseStack.popPose();
            ci.cancel();
            return;
        }
        if (this.visible && SodiumWorkaround.IS_SODIUM_WORKAROUND_NEEDED && (this.children.containsKey("head") || this.children.containsKey("hat"))) {
            poseStack.pushPose();
            this.translateAndRotate(poseStack);
            this.compile(poseStack.last(), vertexConsumer, light, overlay, red, green, blue, alpha);
            for (Map.Entry<String, ModelPart> child : this.children.entrySet()) {
                child.getValue().render(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
            }
            poseStack.popPose();
            ci.cancel();
        }
    }

    @Override
    public void setInjectedMesh(Mesh mesh, OffsetProvider offsetProvider) {
        this.injectedMesh = mesh;
        this.offsetProvider = offsetProvider;
    }

    @Shadow
    public void translateAndRotate(PoseStack poseStack) {
    }

    @Shadow
    public void compile(PoseStack.Pose pose, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    @Override
    public void prepareTranslateAndRotate(PoseStack poseStack) {
        this.translateAndRotate(poseStack);
    }

    @Override
    @Generated
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    @Generated
    public Mesh getInjectedMesh() {
        return this.injectedMesh;
    }

    @Override
    @Generated
    public OffsetProvider getOffsetProvider() {
        return this.offsetProvider;
    }
}

