/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rgpmcsmod.block;

import java.util.Optional;
import net.mcreator.rgpmcsmod.world.teleporter.SkulkPortalShape;
import net.mcreator.rgpmcsmod.world.teleporter.SkulkTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.ITeleporter;

public class SkulkPortalBlock
extends NetherPortalBlock {
    public SkulkPortalBlock() {
        super(BlockBehaviour.Properties.of().noCollission().randomTicks().pushReaction(PushReaction.BLOCK).strength(-1.0f).sound(SoundType.GLASS).lightLevel(s -> 5).noLootTable());
    }

    public void randomTick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    public static void portalSpawn(Level world, BlockPos pos) {
        Optional<SkulkPortalShape> optional = SkulkPortalShape.findEmptyPortalShape((LevelAccessor)world, pos, Direction.Axis.X);
        if (optional.isPresent()) {
            optional.get().createPortalBlocks();
        }
    }

    protected BlockState updateShape(BlockState p_54928_, Direction p_54929_, BlockState p_54930_, LevelAccessor p_54931_, BlockPos p_54932_, BlockPos p_54933_) {
        Direction.Axis direction$axis = p_54929_.getAxis();
        Direction.Axis direction$axis1 = (Direction.Axis)p_54928_.getValue((Property)AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.isHorizontal();
        return !flag && !p_54930_.is((Block)this) && !new SkulkPortalShape(p_54931_, p_54932_, direction$axis1).isComplete() ? Blocks.AIR.defaultBlockState() : super.updateShape(p_54928_, p_54929_, p_54930_, p_54931_, p_54932_, p_54933_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 4; ++i) {
            double px = (float)pos.getX() + random.nextFloat();
            double py = (float)pos.getY() + random.nextFloat();
            double pz = (float)pos.getZ() + random.nextFloat();
            double vx = ((double)random.nextFloat() - 0.5) / 2.0;
            double vy = ((double)random.nextFloat() - 0.5) / 2.0;
            double vz = ((double)random.nextFloat() - 0.5) / 2.0;
            int j = random.nextInt(4) - 1;
            if (world.getBlockState(pos.west()).getBlock() != this && world.getBlockState(pos.east()).getBlock() != this) {
                px = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                vx = random.nextFloat() * 2.0f * (float)j;
            } else {
                pz = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                vz = random.nextFloat() * 2.0f * (float)j;
            }
            world.addParticle((ParticleOptions)ParticleTypes.PORTAL, px, py, pz, vx, vy, vz);
        }
        if (random.nextInt(110) == 0) {
            world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("block.portal.ambient")), SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f);
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.canChangeDimensions() && !entity.level().isClientSide()) {
            if (entity.isOnPortalCooldown()) {
                entity.setPortalCooldown();
            } else if (entity.level().dimension() != ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation("rgpmcs_mod:skulk"))) {
                entity.setPortalCooldown();
                this.teleportToDimension(entity, pos, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation("rgpmcs_mod:skulk")));
            } else {
                entity.setPortalCooldown();
                this.teleportToDimension(entity, pos, (ResourceKey<Level>)Level.OVERWORLD);
            }
        }
    }

    private void teleportToDimension(Entity entity, BlockPos pos, ResourceKey<Level> destinationType) {
        entity.changeDimension(entity.getServer().getLevel(destinationType), (ITeleporter)new SkulkTeleporter(entity.getServer().getLevel(destinationType), pos));
    }
}

