/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rgpmcsmod.entity;

import net.mcreator.rgpmcsmod.init.RgpmcsModModEntities;
import net.mcreator.rgpmcsmod.procedures.PotatooProjectileHitsLivingEntityProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class PotatooProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Items.POTATO);

    public PotatooProjectileEntity(EntityType<? extends PotatooProjectileEntity> type, Level world) {
        super(type, world, PROJECTILE_ITEM);
    }

    public PotatooProjectileEntity(EntityType<? extends PotatooProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM);
    }

    public PotatooProjectileEntity(EntityType<? extends PotatooProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.POTATO);
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        PotatooProjectileHitsLivingEntityProcedure.execute(entityHitResult.getEntity());
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static PotatooProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return PotatooProjectileEntity.shoot(world, entity, source, 4.0f, 10.0, 1);
    }

    public static PotatooProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return PotatooProjectileEntity.shoot(world, entity, source, pullingPower * 4.0f, 10.0, 1);
    }

    public static PotatooProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        PotatooProjectileEntity entityarrow = new PotatooProjectileEntity((EntityType<? extends PotatooProjectileEntity>)((EntityType)RgpmcsModModEntities.POTATOO_PROJECTILE.get()), entity, world);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static PotatooProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        PotatooProjectileEntity entityarrow = new PotatooProjectileEntity((EntityType<? extends PotatooProjectileEntity>)((EntityType)RgpmcsModModEntities.POTATOO_PROJECTILE.get()), entity, entity.level());
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 8.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(10.0);
        entityarrow.setKnockback(1);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

