/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.client.AspectsTooltipConfig;
import dev.overgrown.aspectslib.client.tooltip.AspectTooltipComponent;
import dev.overgrown.aspectslib.client.tooltip.AspectTooltipData;
import dev.overgrown.aspectslib.data.Aspect;
import dev.overgrown.aspectslib.data.AspectManager;
import dev.overgrown.aspectslib.data.ModRegistries;
import dev.overgrown.aspectslib.entity.aura_node.client.AuraNodeVisibilityConfig;
import dev.overgrown.aspectslib.entity.aura_node.render.AuraNodeRenderer;
import dev.overgrown.aspectslib.networking.SyncAspectIdentifierPacket;
import dev.overgrown.aspectslib.registry.ModEntities;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_2960;

public class AspectsLibClient
implements ClientModInitializer {
    public void onInitializeClient() {
        AspectsTooltipConfig.setAlwaysShow(false);
        AuraNodeVisibilityConfig.setAlwaysShow(false);
        EntityRendererRegistry.register(ModEntities.AURA_NODE, AuraNodeRenderer::new);
        TooltipComponentCallback.EVENT.register(data -> {
            if (data instanceof AspectTooltipData) {
                AspectTooltipData aspectTooltipData = (AspectTooltipData)data;
                return new AspectTooltipComponent(aspectTooltipData);
            }
            return null;
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncAspectIdentifierPacket.ID, (client, handler, buf, responseSender) -> {
            try {
                Map<class_2960, Aspect> aspectMap;
                Map<String, class_2960> nameMap = SyncAspectIdentifierPacket.readNameMap(buf);
                if (buf.readableBytes() > 0) {
                    aspectMap = SyncAspectIdentifierPacket.readAspectData(buf);
                } else {
                    aspectMap = new HashMap<class_2960, Aspect>();
                    AspectsLib.LOGGER.warn("Received legacy packet format - only name mapping synced");
                }
                Map<String, class_2960> finalNameMap = nameMap;
                Map<class_2960, Aspect> finalAspectMap = aspectMap;
                client.execute(() -> {
                    AspectManager.NAME_TO_ID.clear();
                    AspectManager.NAME_TO_ID.putAll(finalNameMap);
                    if (!finalAspectMap.isEmpty()) {
                        ModRegistries.ASPECTS.clear();
                        ModRegistries.ASPECTS.putAll(finalAspectMap);
                    }
                    AspectsLib.LOGGER.info("Synced {} aspects from server (name mappings: {})", (Object)finalAspectMap.size(), (Object)finalNameMap.size());
                });
            }
            catch (Exception e) {
                AspectsLib.LOGGER.error("Failed to read aspect sync packet: {}", (Object)e.getMessage());
            }
        });
        AspectsLib.LOGGER.info("AspectsLib Client initialized!");
    }
}

