/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.aether;

import dev.overgrown.aspectslib.aether.AetherChunkData;
import dev.overgrown.aspectslib.aether.AetherManager;
import dev.overgrown.aspectslib.aether.DeadZoneData;
import dev.overgrown.aspectslib.data.AspectData;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;

public class AetherAPI {
    public static boolean canCastSpell(class_1937 world, class_2338 pos, AspectData cost) {
        return AetherAPI.canCastSpell(world, new class_1923(pos), cost);
    }

    public static boolean canCastSpell(class_1937 world, class_1923 chunkPos, AspectData cost) {
        if (AetherManager.isDeadZone(world, chunkPos)) {
            return false;
        }
        AetherChunkData aetherData = AetherManager.getAetherData(world, chunkPos);
        for (Map.Entry entry : cost.getMap().entrySet()) {
            if (aetherData.canHarvest((class_2960)entry.getKey(), (Integer)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean castSpell(class_1937 world, class_2338 pos, AspectData cost) {
        return AetherAPI.castSpell(world, new class_1923(pos), cost);
    }

    public static boolean castSpell(class_1937 world, class_1923 chunkPos, AspectData cost) {
        if (AetherManager.isDeadZone(world, chunkPos)) {
            return false;
        }
        AetherChunkData aetherData = AetherManager.getAetherData(world, chunkPos);
        for (Map.Entry entry : cost.getMap().entrySet()) {
            if (aetherData.canHarvest((class_2960)entry.getKey(), (Integer)entry.getValue())) continue;
            return false;
        }
        boolean allHarvested = true;
        for (Map.Entry entry : cost.getMap().entrySet()) {
            if (aetherData.harvestAether((class_2960)entry.getKey(), (Integer)entry.getValue())) continue;
            allHarvested = false;
            break;
        }
        return allHarvested;
    }

    public static int getAetherLevel(class_1937 world, class_2338 pos, class_2960 aspectId) {
        return AetherAPI.getAetherLevel(world, new class_1923(pos), aspectId);
    }

    public static int getAetherLevel(class_1937 world, class_1923 chunkPos, class_2960 aspectId) {
        if (AetherManager.isDeadZone(world, chunkPos)) {
            return 0;
        }
        AetherChunkData aetherData = AetherManager.getAetherData(world, chunkPos);
        return aetherData.getCurrentAether(aspectId);
    }

    public static int getAetherCapacity(class_1937 world, class_2338 pos, class_2960 aspectId) {
        return AetherAPI.getAetherCapacity(world, new class_1923(pos), aspectId);
    }

    public static int getAetherCapacity(class_1937 world, class_1923 chunkPos, class_2960 aspectId) {
        if (AetherManager.isDeadZone(world, chunkPos)) {
            return 0;
        }
        AetherChunkData aetherData = AetherManager.getAetherData(world, chunkPos);
        return aetherData.getMaxAether(aspectId);
    }

    public static double getAetherPercentage(class_1937 world, class_2338 pos, class_2960 aspectId) {
        return AetherAPI.getAetherPercentage(world, new class_1923(pos), aspectId);
    }

    public static double getAetherPercentage(class_1937 world, class_1923 chunkPos, class_2960 aspectId) {
        if (AetherManager.isDeadZone(world, chunkPos)) {
            return 0.0;
        }
        AetherChunkData aetherData = AetherManager.getAetherData(world, chunkPos);
        return aetherData.getAetherPercentage(aspectId);
    }

    public static boolean isDeadZone(class_1937 world, class_2338 pos) {
        return AetherAPI.isDeadZone(world, new class_1923(pos));
    }

    public static boolean isDeadZone(class_1937 world, class_1923 chunkPos) {
        return AetherManager.isDeadZone(world, chunkPos);
    }

    public static boolean isPermanentDeadZone(class_1937 world, class_2338 pos) {
        return AetherAPI.isPermanentDeadZone(world, new class_1923(pos));
    }

    public static boolean isPermanentDeadZone(class_1937 world, class_1923 chunkPos) {
        DeadZoneData deadZoneData = AetherManager.getDeadZoneData(world, chunkPos);
        return deadZoneData != null && deadZoneData.isPermanent();
    }

    public static void forceRecovery(class_1937 world, class_2338 pos) {
        AetherAPI.forceRecovery(world, new class_1923(pos));
    }

    public static void forceRecovery(class_1937 world, class_1923 chunkPos) {
        if (!AetherManager.isDeadZone(world, chunkPos)) {
            AetherChunkData aetherData = AetherManager.getAetherData(world, chunkPos);
            aetherData.recoverAether();
        }
    }

    public static void createTemporaryDeadZone(class_1937 world, class_2338 pos) {
        AetherAPI.createTemporaryDeadZone(world, new class_1923(pos));
    }

    public static void createTemporaryDeadZone(class_1937 world, class_1923 chunkPos) {
        AetherManager.markAsDeadZone(world, chunkPos, new DeadZoneData(false, world.method_8510()));
    }

    public static void createPermanentDeadZone(class_1937 world, class_2338 pos) {
        AetherAPI.createPermanentDeadZone(world, new class_1923(pos));
    }

    public static void createPermanentDeadZone(class_1937 world, class_1923 chunkPos) {
        AetherManager.markAsDeadZone(world, chunkPos, new DeadZoneData(true, world.method_8510()));
    }

    public static void removeDeadZone(class_1937 world, class_2338 pos) {
        AetherAPI.removeDeadZone(world, new class_1923(pos));
    }

    public static void removeDeadZone(class_1937 world, class_1923 chunkPos) {
        AetherManager.removeDeadZone(world, chunkPos);
    }
}

