/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.aether;

import dev.overgrown.aspectslib.aether.AetherChunkData;
import dev.overgrown.aspectslib.aether.AetherManager;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AetherEvents {
    public static void initialize() {
        ServerWorldEvents.LOAD.register((server, world) -> AetherManager.setServer(server));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % 100 == 0) {
                AetherEvents.processAetherRecovery(server);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> AetherManager.saveAllData());
    }

    private static void processAetherRecovery(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            List<class_2818> loadedChunks = AetherEvents.getLoadedChunks(world);
            for (class_2818 chunk : loadedChunks) {
                class_1923 chunkPos = chunk.method_12004();
                AetherChunkData chunkData = AetherManager.getAetherData((class_1937)world, chunkPos);
                chunkData.recoverAether();
            }
        }
    }

    private static List<class_2818> getLoadedChunks(class_3218 world) {
        ArrayList<class_2818> chunks = new ArrayList<class_2818>();
        class_3215 chunkManager = world.method_14178();
        for (class_3222 player : world.method_18456()) {
            class_1923 chunkPos = player.method_31476();
            class_2818 chunk = chunkManager.method_21730(chunkPos.field_9181, chunkPos.field_9180);
            if (chunk == null || chunks.contains(chunk)) continue;
            chunks.add(chunk);
        }
        return chunks;
    }
}

