/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.aether;

import dev.overgrown.aspectslib.aether.AetherChunkData;
import dev.overgrown.aspectslib.aether.DeadZoneData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class AetherWorldState
extends class_18 {
    private final Map<class_1923, AetherChunkData> chunkData = new HashMap<class_1923, AetherChunkData>();
    private final Map<class_1923, DeadZoneData> deadZones = new HashMap<class_1923, DeadZoneData>();
    private class_1937 world;

    public AetherChunkData getOrCreateChunkData(class_1923 chunkPos, class_1937 world) {
        this.world = world;
        return this.chunkData.computeIfAbsent(chunkPos, pos -> {
            AetherChunkData data = new AetherChunkData(world, (class_1923)pos);
            this.method_80();
            return data;
        });
    }

    public void markAsDeadZone(class_1923 chunkPos, DeadZoneData data) {
        this.chunkData.remove(chunkPos);
        this.deadZones.put(chunkPos, data);
        this.method_80();
    }

    public void removeDeadZone(class_1923 chunkPos) {
        this.deadZones.remove(chunkPos);
        this.method_80();
    }

    public boolean isDeadZone(class_1923 chunkPos) {
        return this.deadZones.containsKey(chunkPos);
    }

    public DeadZoneData getDeadZoneData(class_1923 chunkPos) {
        return this.deadZones.get(chunkPos);
    }

    public Collection<AetherChunkData> getAllChunkData() {
        return this.chunkData.values();
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 chunkDataList = new class_2499();
        for (Map.Entry<class_1923, AetherChunkData> entry : this.chunkData.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            class_2487 chunkNbt = new class_2487();
            chunkNbt.method_10544("Pos", entry.getKey().method_8324());
            chunkNbt.method_10566("Data", (class_2520)entry.getValue().toNbt());
            chunkDataList.add((Object)chunkNbt);
        }
        nbt.method_10566("ChunkData", (class_2520)chunkDataList);
        class_2499 deadZoneList = new class_2499();
        for (Map.Entry<class_1923, DeadZoneData> entry : this.deadZones.entrySet()) {
            class_2487 deadZoneNbt = new class_2487();
            deadZoneNbt.method_10544("Pos", entry.getKey().method_8324());
            deadZoneNbt.method_10566("DeadZoneData", (class_2520)entry.getValue().toNbt());
            deadZoneList.add((Object)deadZoneNbt);
        }
        nbt.method_10566("DeadZones", (class_2520)deadZoneList);
        return nbt;
    }

    public static AetherWorldState fromNbt(class_2487 nbt) {
        Object data;
        class_1923 pos;
        int i;
        AetherWorldState state = new AetherWorldState();
        if (nbt.method_10573("ChunkData", 9)) {
            class_2499 chunkDataList = nbt.method_10554("ChunkData", 10);
            for (i = 0; i < chunkDataList.size(); ++i) {
                class_2487 chunkNbt = chunkDataList.method_10602(i);
                pos = new class_1923(chunkNbt.method_10537("Pos"));
                data = AetherChunkData.fromNbt(chunkNbt.method_10562("Data"));
                state.chunkData.put(pos, (AetherChunkData)data);
            }
        }
        if (nbt.method_10573("DeadZones", 9)) {
            class_2499 deadZoneList = nbt.method_10554("DeadZones", 10);
            for (i = 0; i < deadZoneList.size(); ++i) {
                class_2487 deadZoneNbt = deadZoneList.method_10602(i);
                pos = new class_1923(deadZoneNbt.method_10537("Pos"));
                data = DeadZoneData.fromNbt(deadZoneNbt.method_10562("DeadZoneData"));
                state.deadZones.put(pos, (DeadZoneData)data);
            }
        }
        return state;
    }
}

