/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import java.util.function.Supplier;

public class CodecUtils {
    public static <A> Codec<A> withAlternative(final Codec<A> primary, final Codec<A> alternative) {
        return new Codec<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                DataResult primaryResult = primary.decode(ops, input);
                if (primaryResult.result().isPresent()) {
                    return primaryResult;
                }
                return alternative.decode(ops, input);
            }

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                return primary.encode(input, ops, prefix);
            }
        };
    }

    public static <A, B> Codec<A> withAlternative(final Codec<A> primary, final Codec<B> alternative, final Function<B, A> mapper) {
        return new Codec<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                DataResult primaryResult = primary.decode(ops, input);
                if (primaryResult.result().isPresent()) {
                    return primaryResult;
                }
                return alternative.decode(ops, input).map(pair -> Pair.of(mapper.apply(pair.getFirst()), (Object)pair.getSecond()));
            }

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                return primary.encode(input, ops, prefix);
            }
        };
    }

    public static <A> Codec<A> lazy(final Supplier<Codec<A>> supplier) {
        return new Codec<A>(){
            private Codec<A> delegate = null;

            private Codec<A> getDelegate() {
                if (this.delegate == null) {
                    this.delegate = (Codec)supplier.get();
                }
                return this.delegate;
            }

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                return this.getDelegate().decode(ops, input);
            }

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                return this.getDelegate().encode(input, ops, prefix);
            }
        };
    }
}

