/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.overgrown.aspectslib.api.AspectsAPI;
import dev.overgrown.aspectslib.data.Aspect;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.BiomeAspectModifier;
import dev.overgrown.aspectslib.data.ModRegistries;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_7157;

public class AspectDebugCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"aspectdebug").requires(source -> source.method_9259(2))).executes(AspectDebugCommand::showHeldItemAspects)).then(class_2170.method_9247((String)"item").executes(AspectDebugCommand::showHeldItemAspects))).then(class_2170.method_9247((String)"entity").executes(AspectDebugCommand::showLookingAtEntity))).then(class_2170.method_9247((String)"block").executes(AspectDebugCommand::showLookingAtBlock))).then(class_2170.method_9247((String)"biome").executes(AspectDebugCommand::showCurrentBiome)));
    }

    private static int showHeldItemAspects(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        class_1799 heldItem = player.method_6047();
        if (heldItem.method_7960()) {
            source.method_9226(() -> class_2561.method_43470((String)"You're not holding any item"), false);
            return 0;
        }
        AspectData aspectData = AspectsAPI.getAspectData(heldItem);
        if (aspectData.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)("Item '" + heldItem.method_7909().method_7848().getString() + "' has no aspects")), false);
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Aspects for '" + heldItem.method_7909().method_7848().getString() + "':")), false);
        for (Object2IntMap.Entry entry : aspectData.getMap().object2IntEntrySet()) {
            class_2960 aspectId = (class_2960)entry.getKey();
            int amount = entry.getIntValue();
            Aspect aspect = ModRegistries.ASPECTS.get(aspectId);
            String aspectName = aspect != null ? aspect.name() : aspectId.toString();
            source.method_9226(() -> class_2561.method_43470((String)("  " + aspectName + ": " + amount)), false);
        }
        return 1;
    }

    private static int showLookingAtEntity(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        class_1297 targetEntity = AspectDebugCommand.getTargetedEntity(player, 20.0);
        if (targetEntity == null) {
            source.method_9226(() -> class_2561.method_43470((String)"You're not looking at any entity"), false);
            return 0;
        }
        class_1297 entity = targetEntity;
        class_2960 entityId = entity.method_5864().method_40124().method_40237().method_29177();
        AspectData aspectData = AspectsAPI.getEntityAspectData(entityId);
        if (aspectData.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)("Entity '" + entity.method_5864().method_5897().getString() + "' has no aspects")), false);
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Aspects for entity '" + entity.method_5864().method_5897().getString() + "':")), false);
        for (Object2IntMap.Entry entry : aspectData.getMap().object2IntEntrySet()) {
            class_2960 aspectId = (class_2960)entry.getKey();
            int amount = entry.getIntValue();
            Aspect aspect = ModRegistries.ASPECTS.get(aspectId);
            String aspectName = aspect != null ? aspect.name() : aspectId.toString();
            source.method_9226(() -> class_2561.method_43470((String)("  " + aspectName + ": " + amount)), false);
        }
        return 1;
    }

    private static int showLookingAtBlock(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        class_239 hitResult = player.method_5745(20.0, 0.0f, false);
        if (!(hitResult instanceof class_3965)) {
            source.method_9226(() -> class_2561.method_43470((String)"You're not looking at any block"), false);
            return 0;
        }
        class_3965 blockHit = (class_3965)hitResult;
        class_2338 pos = blockHit.method_17777();
        class_2680 blockState = player.method_37908().method_8320(pos);
        class_2960 blockId = blockState.method_26204().method_40142().method_40237().method_29177();
        AspectData aspectData = AspectsAPI.getBlockAspectData(blockId);
        if (aspectData.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)("Block '" + blockState.method_26204().method_9518().getString() + "' has no aspects")), false);
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Aspects for block '" + blockState.method_26204().method_9518().getString() + "':")), false);
        for (Object2IntMap.Entry entry : aspectData.getMap().object2IntEntrySet()) {
            class_2960 aspectId = (class_2960)entry.getKey();
            int amount = entry.getIntValue();
            Aspect aspect = ModRegistries.ASPECTS.get(aspectId);
            String aspectName = aspect != null ? aspect.name() : aspectId.toString();
            source.method_9226(() -> class_2561.method_43470((String)("  " + aspectName + ": " + amount)), false);
        }
        return 1;
    }

    private static int showCurrentBiome(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        class_2338 pos = player.method_24515();
        class_5321 biomeKey = player.method_37908().method_23753(pos).method_40230().orElse(null);
        if (biomeKey == null) {
            source.method_9226(() -> class_2561.method_43470((String)"Could not determine current biome"), false);
            return 0;
        }
        class_2960 biomeId = biomeKey.method_29177();
        AspectData aspectData = BiomeAspectModifier.getCombinedBiomeAspects(biomeId);
        if (aspectData.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)("Biome '" + biomeKey.method_29177().toString() + "' has no aspects")), false);
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Aspects for biome '" + biomeKey.method_29177().toString() + "':")), false);
        for (Object2IntMap.Entry entry : aspectData.getMap().object2IntEntrySet()) {
            class_2960 aspectId = (class_2960)entry.getKey();
            int amount = entry.getIntValue();
            Aspect aspect = ModRegistries.ASPECTS.get(aspectId);
            String aspectName = aspect != null ? aspect.name() : aspectId.toString();
            source.method_9226(() -> class_2561.method_43470((String)("  " + aspectName + ": " + amount)), false);
        }
        return 1;
    }

    private static class_1297 getTargetedEntity(class_3222 player, double maxDistance) {
        class_243 eyePos = player.method_33571();
        class_243 lookVec = player.method_5828(1.0f);
        class_243 endPos = eyePos.method_1019(lookVec.method_1021(maxDistance));
        class_238 searchBox = player.method_5829().method_18804(lookVec.method_1021(maxDistance)).method_1014(1.0);
        double closestDistance = maxDistance;
        class_1297 closestEntity = null;
        for (class_1297 entity : player.method_37908().method_8335((class_1297)player, searchBox)) {
            double distance;
            class_238 entityBox = entity.method_5829().method_1014((double)entity.method_5871());
            Optional hitPos = entityBox.method_992(eyePos, endPos);
            if (!hitPos.isPresent() || !((distance = eyePos.method_1022((class_243)hitPos.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        return closestEntity;
    }
}

