/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.overgrown.aspectslib.corruption.CorruptionAPI;
import dev.overgrown.aspectslib.data.BiomeAspectModifier;
import net.minecraft.class_1297;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7924;

public class CorruptionCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"corruption").requires(source -> source.method_9259(2))).executes(CorruptionCommand::checkCurrentBiome)).then(class_2170.method_9247((String)"purify").executes(CorruptionCommand::purifyCurrentBiome))).then(class_2170.method_9247((String)"force").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(CorruptionCommand::forceCorruption))));
    }

    private static int checkCurrentBiome(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        class_1959 biome = (class_1959)player.method_37908().method_23753(player.method_24515()).comp_349();
        class_2960 biomeId = player.method_37908().method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        if (biomeId == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Could not determine current biome"));
            return 0;
        }
        int corruptionState = CorruptionAPI.getBiomeCorruptionState(biomeId);
        int vitiumAmount = CorruptionAPI.getVitiumAmount(biomeId);
        String state = switch (corruptionState) {
            case 0 -> "\u00a7aPure";
            case 1 -> "\u00a7eTainted";
            case 2 -> "\u00a7cCorrupted";
            default -> "\u00a77Unknown";
        };
        source.method_9226(() -> class_2561.method_43470((String)("Biome: " + biomeId.toString())), false);
        source.method_9226(() -> class_2561.method_43470((String)("State: " + state)), false);
        source.method_9226(() -> class_2561.method_43470((String)("Vitium: " + vitiumAmount)), false);
        return 1;
    }

    private static int purifyCurrentBiome(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        class_1959 biome = (class_1959)player.method_37908().method_23753(player.method_24515()).comp_349();
        class_2960 biomeId = player.method_37908().method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        if (biomeId == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Could not determine current biome"));
            return 0;
        }
        int vitiumBefore = CorruptionAPI.getVitiumAmount(biomeId);
        CorruptionAPI.purifyBiome(biomeId);
        BiomeAspectModifier.applyModificationsToRegistry();
        int vitiumAfter = CorruptionAPI.getVitiumAmount(biomeId);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aPurified biome: " + String.valueOf(biomeId) + " (Removed " + (vitiumBefore - vitiumAfter) + " Vitium)")), true);
        return 1;
    }

    private static int forceCorruption(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        class_1959 biome = (class_1959)player.method_37908().method_23753(player.method_24515()).comp_349();
        class_2960 biomeId = player.method_37908().method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        if (biomeId == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Could not determine current biome"));
            return 0;
        }
        CorruptionAPI.forceCorruption(biomeId, amount);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7cForced corruption in biome: " + String.valueOf(biomeId) + " (+" + amount + " Vitium)")), true);
        return 1;
    }
}

