/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.overgrown.aspectslib.AspectsLib;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class TagDumpCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tagdump").requires(source -> source.method_9259(2))).executes(TagDumpCommand::dumpAllTags)).then(class_2170.method_9247((String)"item").executes(TagDumpCommand::dumpItemTags)));
    }

    private static int dumpAllTags(CommandContext<class_2168> context) {
        return TagDumpCommand.dumpItemTags(context);
    }

    private static int dumpItemTags(CommandContext<class_2168> context) {
        List items;
        List<class_2960> tags;
        String namespace;
        class_2168 source = (class_2168)context.getSource();
        HashSet allTags = new HashSet();
        HashMap tagToItems = new HashMap();
        for (class_1792 item2 : class_7923.field_41178) {
            if (item2 == class_1802.field_8162) continue;
            item2.method_40131().method_40228().forEach(tagKey -> {
                class_2960 tagId = tagKey.comp_327();
                allTags.add(tagId);
                tagToItems.computeIfAbsent(tagId, k -> new ArrayList()).add(item2);
            });
        }
        List sortedTags = allTags.stream().sorted(Comparator.comparing(class_2960::method_12836).thenComparing(class_2960::method_12832)).collect(Collectors.toList());
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7a=== Item Tags Dump ==="), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eFound " + sortedTags.size() + " unique item tags")), false);
        Map<String, List<class_2960>> byNamespace = sortedTags.stream().collect(Collectors.groupingBy(class_2960::method_12836));
        for (Map.Entry<String, List<class_2960>> namespaceEntry : byNamespace.entrySet()) {
            namespace = namespaceEntry.getKey();
            tags = namespaceEntry.getValue();
            source.method_9226(() -> class_2561.method_43470((String)("\u00a76[" + namespace + "] (" + tags.size() + " tags):")), false);
            for (class_2960 tagId : tags) {
                items = (List)tagToItems.get(tagId);
                String tagPath = tagId.method_12832();
                int itemCount = items != null ? items.size() : 0;
                Object examples = "";
                if (items != null && !items.isEmpty()) {
                    examples = items.stream().limit(3L).map(item -> class_7923.field_41178.method_10221(item).method_12832()).collect(Collectors.joining(", "));
                    if (items.size() > 3) {
                        examples = (String)examples + ", ...";
                    }
                }
                String finalExamples = examples;
                source.method_9226(() -> class_2561.method_43470((String)("  \u00a77- " + tagPath + " \u00a78(" + itemCount + " items) \u00a73" + finalExamples)), false);
            }
        }
        AspectsLib.LOGGER.info("=== Item Tags Dump ===");
        AspectsLib.LOGGER.info("Found {} unique item tags", (Object)sortedTags.size());
        for (Map.Entry<String, List<class_2960>> namespaceEntry : byNamespace.entrySet()) {
            namespace = namespaceEntry.getKey();
            tags = namespaceEntry.getValue();
            AspectsLib.LOGGER.info("[{}] ({} tags):", (Object)namespace, (Object)tags.size());
            for (class_2960 tagId : tags) {
                items = (List)tagToItems.get(tagId);
                int itemCount = items != null ? items.size() : 0;
                AspectsLib.LOGGER.info("  - {} ({} items)", (Object)tagId, (Object)itemCount);
            }
        }
        return 1;
    }
}

