/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.corruption;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.corruption.CorruptionChunkData;
import dev.overgrown.aspectslib.corruption.CorruptionDataManager;
import dev.overgrown.aspectslib.corruption.CorruptionManager;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.BiomeAspectModifier;
import java.util.Collection;
import net.minecraft.class_1923;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class CorruptionAPI {
    public static int getBiomeCorruptionState(class_2960 biomeId) {
        return CorruptionManager.getCorruptionState(biomeId);
    }

    public static boolean isBiomePure(class_2960 biomeId) {
        return CorruptionManager.isBiomePure(biomeId);
    }

    public static boolean isBiomeTainted(class_2960 biomeId) {
        return CorruptionManager.isBiomeTainted(biomeId);
    }

    public static boolean isBiomeCorrupted(class_2960 biomeId) {
        return CorruptionManager.isBiomeCorrupted(biomeId);
    }

    public static void forceCorruption(class_2960 biomeId, int vitiumAmount) {
        class_2960 vitiumId = AspectsLib.identifier("vitium");
        BiomeAspectModifier.addBiomeModification(biomeId, vitiumId, vitiumAmount);
        AspectsLib.LOGGER.info("Forced corruption on biome {} by adding {} Vitium", (Object)biomeId, (Object)vitiumAmount);
    }

    public static void purifyBiome(class_2960 biomeId) {
        class_2960 vitiumId = AspectsLib.identifier("vitium");
        AspectData currentAspects = BiomeAspectModifier.getCombinedBiomeAspects(biomeId);
        int vitiumAmount = currentAspects.getLevel(vitiumId);
        if (vitiumAmount > 0) {
            BiomeAspectModifier.addBiomeModification(biomeId, vitiumId, -vitiumAmount);
            AspectsLib.LOGGER.info("Purified biome {} by removing {} Vitium", (Object)biomeId, (Object)vitiumAmount);
        } else {
            AspectsLib.LOGGER.info("Biome {} has no Vitium to purify", (Object)biomeId);
        }
    }

    public static int getVitiumAmount(class_2960 biomeId) {
        class_2960 vitiumId = AspectsLib.identifier("vitium");
        AspectData aspects = BiomeAspectModifier.getCombinedBiomeAspects(biomeId);
        return aspects.getLevel(vitiumId);
    }

    public static CorruptionChunkData getChunkData(class_3218 world, class_1923 chunkPos) {
        return CorruptionDataManager.getChunkData(world, chunkPos);
    }

    public static Collection<CorruptionChunkData> getTrackedChunks(class_3218 world) {
        return CorruptionDataManager.getAll(world);
    }
}

