/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.corruption;

import dev.overgrown.aspectslib.corruption.CorruptionChunkData;
import dev.overgrown.aspectslib.corruption.CorruptionWorldState;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public final class CorruptionDataManager {
    private static final String CORRUPTION_STATE_KEY = "aspectslib_corruption";

    private CorruptionDataManager() {
    }

    public static CorruptionWorldState getWorldState(class_3218 world) {
        class_26 manager = world.method_17983();
        return (CorruptionWorldState)manager.method_17924(CorruptionWorldState::fromNbt, CorruptionWorldState::new, CORRUPTION_STATE_KEY);
    }

    public static void updateChunkStatus(class_3218 world, class_1923 chunkPos, class_2960 biomeId, CorruptionChunkData.Status status, long tick) {
        CorruptionWorldState state = CorruptionDataManager.getWorldState(world);
        CorruptionChunkData data = state.getOrCreate(chunkPos);
        boolean changed = data.setStatus(status, biomeId, tick);
        if (changed) {
            state.method_80();
        }
        if (data.isPrunable()) {
            state.pruneIfClean(chunkPos);
        }
    }

    public static void recordAspectDelta(class_3218 world, class_1923 chunkPos, class_2960 biomeId, class_2960 aspectId, int delta, long tick) {
        if (delta == 0) {
            return;
        }
        CorruptionWorldState state = CorruptionDataManager.getWorldState(world);
        CorruptionChunkData data = state.getOrCreate(chunkPos);
        boolean changed = data.recordAspectDelta(aspectId, delta, biomeId, tick);
        if (changed) {
            state.method_80();
        }
        if (data.isPrunable()) {
            state.pruneIfClean(chunkPos);
        }
    }

    public static void recordBulkAspectDelta(class_3218 world, Collection<class_1923> chunkPositions, class_2960 biomeId, class_2960 aspectId, int delta, long tick) {
        for (class_1923 chunkPos : chunkPositions) {
            CorruptionDataManager.recordAspectDelta(world, chunkPos, biomeId, aspectId, delta, tick);
        }
    }

    public static void recordAetherConsumption(class_3218 world, class_1923 chunkPos, class_2960 biomeId, class_2960 aspectId, int amount, long tick) {
        if (amount <= 0) {
            return;
        }
        CorruptionWorldState state = CorruptionDataManager.getWorldState(world);
        CorruptionChunkData data = state.getOrCreate(chunkPos);
        boolean changed = data.recordAetherConsumption(aspectId, amount, biomeId, tick);
        if (changed) {
            state.method_80();
        }
    }

    public static void recordSculkPlacement(class_3218 world, class_1923 chunkPos, int count, long tick) {
        if (count <= 0) {
            return;
        }
        CorruptionWorldState state = CorruptionDataManager.getWorldState(world);
        CorruptionChunkData data = state.getOrCreate(chunkPos);
        boolean changed = data.recordSculkPlacement(count, tick);
        if (changed) {
            state.method_80();
        }
    }

    public static Collection<CorruptionChunkData> getAll(class_3218 world) {
        return List.copyOf(CorruptionDataManager.getWorldState(world).getAll());
    }

    public static CorruptionChunkData getChunkData(class_3218 world, class_1923 chunkPos) {
        return CorruptionDataManager.getWorldState(world).get(chunkPos);
    }
}

