/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.corruption;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.aether.AetherChunkData;
import dev.overgrown.aspectslib.aether.AetherManager;
import dev.overgrown.aspectslib.aether.DeadZoneData;
import dev.overgrown.aspectslib.corruption.CorruptionChunkData;
import dev.overgrown.aspectslib.corruption.CorruptionDataManager;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.BiomeAspectModifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class CorruptionManager {
    public static final class_2960 VITIUM_ID = AspectsLib.identifier("vitium");
    private static final Map<class_2960, CorruptionState> CORRUPTION_STATES = new HashMap<class_2960, CorruptionState>();
    private static final Random RANDOM = new Random();
    private static final int CORRUPTION_CHECK_INTERVAL = 200;
    private static final int ASPECT_CONSUMPTION_INTERVAL = 400;
    private static final int AETHER_CONSUMPTION_INTERVAL = 1200;
    private static final int SCULK_SPREAD_CHANCE = 20;
    private static final int MAX_SCULK_PER_CHUNK = 64;
    private static final double PERMANENT_DEAD_ZONE_CHANCE = 0.1;

    public static void initialize() {
        ServerTickEvents.START_SERVER_TICK.register(CorruptionManager::onServerTick);
    }

    private static void onServerTick(MinecraftServer server) {
        long time = server.method_30002().method_8510();
        if (time % 200L != 0L) {
            return;
        }
        for (class_3218 world : server.method_3738()) {
            CorruptionManager.processWorldCorruption(world, time);
        }
    }

    private static void processWorldCorruption(class_3218 world, long currentTime) {
        Set<class_1923> loadedChunks = CorruptionManager.getLoadedChunks(world);
        HashMap<class_2960, List> chunksByBiome = new HashMap<class_2960, List>();
        for (class_1923 class_19232 : loadedChunks) {
            class_2338 centerPos = class_19232.method_8323().method_10069(8, 64, 8);
            class_1959 biome = (class_1959)world.method_23753(centerPos).comp_349();
            class_2960 biomeId = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
            if (biomeId == null) continue;
            chunksByBiome.computeIfAbsent(biomeId, k -> new ArrayList()).add(class_19232);
        }
        for (Map.Entry entry : chunksByBiome.entrySet()) {
            class_2960 biomeId = (class_2960)entry.getKey();
            List biomesChunks = (List)entry.getValue();
            class_1923 representativeChunk = (class_1923)biomesChunks.get(0);
            CorruptionManager.processBiomeCorruption(world, biomeId, biomesChunks, representativeChunk, currentTime);
        }
        CORRUPTION_STATES.entrySet().removeIf(stateEntry -> !chunksByBiome.containsKey(stateEntry.getKey()) && ((CorruptionState)stateEntry.getValue()).lastSeen + 6000L < world.method_8510());
    }

    private static void processBiomeCorruption(class_3218 world, class_2960 biomeId, List<class_1923> biomesChunks, class_1923 representativeChunk, long currentTime) {
        int currentTotalOtherAspects;
        AspectData currentBiomeAspects = BiomeAspectModifier.getCombinedBiomeAspects(biomeId);
        int currentVitiumAmount = currentBiomeAspects.getLevel(VITIUM_ID);
        if (currentVitiumAmount == 0) {
            CorruptionManager.updateChunkStatuses(world, biomesChunks, biomeId, CorruptionChunkData.Status.PURE, currentTime);
            CorruptionManager.updateCorruptionState(biomeId, 0, world.method_8510());
            return;
        }
        int baseTotalForComparison = currentTotalOtherAspects = CorruptionManager.calculateTotalOtherAspects(currentBiomeAspects);
        if (AspectsLib.LOGGER.isDebugEnabled()) {
            AspectsLib.LOGGER.debug("Biome {} aspects - Vitium: {}, Other aspects total: {}", new Object[]{biomeId, currentVitiumAmount, baseTotalForComparison});
            for (class_2960 aspectId : currentBiomeAspects.getAspectIds()) {
                int amount = currentBiomeAspects.getLevel(aspectId);
                if (aspectId.equals((Object)VITIUM_ID)) continue;
                AspectsLib.LOGGER.debug("  {}: {}", (Object)aspectId, (Object)amount);
            }
        }
        if (currentVitiumAmount > baseTotalForComparison) {
            CorruptionManager.updateChunkStatuses(world, biomesChunks, biomeId, CorruptionChunkData.Status.CORRUPTED, currentTime);
            CorruptionState state = CORRUPTION_STATES.computeIfAbsent(biomeId, id -> new CorruptionState(2, world.method_8510()));
            if (state.state != 2) {
                state.state = 2;
                AspectsLib.LOGGER.info("Biome {} became corrupted! Vitium: {} > Other aspects total: {}", new Object[]{biomeId, currentVitiumAmount, baseTotalForComparison});
            }
            state.lastSeen = world.method_8510();
            CorruptionManager.processCorruption(world, biomesChunks, biomeId, representativeChunk, currentBiomeAspects, currentTime);
            if (currentTotalOtherAspects == 0 && currentVitiumAmount > 0 && currentTime % 1200L == 0L) {
                CorruptionManager.processAetherConsumption(world, representativeChunk, biomeId, currentTime);
            }
        } else {
            CorruptionManager.updateChunkStatuses(world, biomesChunks, biomeId, CorruptionChunkData.Status.TAINTED, currentTime);
            CorruptionManager.updateCorruptionState(biomeId, 1, world.method_8510());
            AspectsLib.LOGGER.debug("Biome {} is tainted. Vitium: {} <= Other aspects total: {} (needs to be > {} to corrupt)", new Object[]{biomeId, currentVitiumAmount, baseTotalForComparison, baseTotalForComparison});
        }
    }

    private static void updateChunkStatuses(class_3218 world, List<class_1923> chunkPositions, class_2960 biomeId, CorruptionChunkData.Status status, long tick) {
        for (class_1923 chunkPos : chunkPositions) {
            CorruptionDataManager.updateChunkStatus(world, chunkPos, biomeId, status, tick);
        }
    }

    private static int calculateTotalOtherAspects(AspectData aspects) {
        int total = 0;
        for (class_2960 aspectId : aspects.getAspectIds()) {
            if (aspectId.equals((Object)VITIUM_ID)) continue;
            total += aspects.getLevel(aspectId);
        }
        return total;
    }

    private static void processCorruption(class_3218 world, List<class_1923> biomesChunks, class_2960 biomeId, class_1923 representativeChunk, AspectData currentAspects, long currentTime) {
        if (RANDOM.nextInt(100) < 20) {
            class_1923 randomChunk = biomesChunks.get(RANDOM.nextInt(biomesChunks.size()));
            CorruptionManager.spreadSculk(world, randomChunk, currentTime);
        }
        if (currentTime % 400L == 0L) {
            CorruptionManager.consumeAspects(biomeId, currentAspects).ifPresent(result -> {
                CorruptionDataManager.recordAspectDelta(world, representativeChunk, biomeId, result.aspectId(), -1, currentTime);
                int vitiumDelta = result.vitiumAfter() - result.vitiumBefore();
                if (vitiumDelta != 0) {
                    CorruptionDataManager.recordAspectDelta(world, representativeChunk, biomeId, VITIUM_ID, vitiumDelta, currentTime);
                }
            });
        }
    }

    private static void spreadSculk(class_3218 world, class_1923 chunkPos, long currentTime) {
        int sculkCount = 0;
        for (int i = 0; i < 3 && sculkCount < 64; ++i) {
            int z;
            int x = chunkPos.method_8326() + RANDOM.nextInt(16);
            class_2338 pos = CorruptionManager.findSurfacePosition((class_1937)world, new class_2338(x, 0, z = chunkPos.method_8328() + RANDOM.nextInt(16)));
            if (pos == null || !world.method_8320(pos).method_26215() || !world.method_8320(pos.method_10074()).method_26225()) continue;
            world.method_8501(pos, class_2246.field_37568.method_9564());
            ++sculkCount;
            CorruptionDataManager.recordSculkPlacement(world, chunkPos, 1, currentTime);
            world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_37357, class_3419.field_15245, 1.0f, 0.8f + RANDOM.nextFloat() * 0.4f);
            AspectsLib.LOGGER.debug("Placed sculk at {} in chunk {}", (Object)pos, (Object)chunkPos);
        }
    }

    private static class_2338 findSurfacePosition(class_1937 world, class_2338 pos) {
        for (int y = world.method_31600(); y >= world.method_31607(); --y) {
            class_2338 currentPos = new class_2338(pos.method_10263(), y, pos.method_10260());
            if (!world.method_8320(currentPos).method_26225()) continue;
            return currentPos.method_10084();
        }
        return null;
    }

    private static Optional<AspectConsumptionResult> consumeAspects(class_2960 biomeId, AspectData currentAspects) {
        ArrayList<class_2960> nonVitiumAspects = new ArrayList<class_2960>();
        for (class_2960 aspectId : currentAspects.getAspectIds()) {
            if (aspectId.equals((Object)VITIUM_ID) || currentAspects.getLevel(aspectId) <= 0) continue;
            nonVitiumAspects.add(aspectId);
        }
        if (nonVitiumAspects.isEmpty()) {
            AspectsLib.LOGGER.debug("No non-Vitium aspects left to consume in biome {}", (Object)biomeId);
            return Optional.empty();
        }
        class_2960 targetAspect = (class_2960)nonVitiumAspects.get(RANDOM.nextInt(nonVitiumAspects.size()));
        int currentAmount = currentAspects.getLevel(targetAspect);
        if (currentAmount > 0) {
            int previousVitiumAmount = currentAspects.getLevel(VITIUM_ID);
            BiomeAspectModifier.addBiomeModification(biomeId, targetAspect, -1);
            BiomeAspectModifier.addBiomeModification(biomeId, VITIUM_ID, 1);
            BiomeAspectModifier.applyModificationsToRegistry();
            AspectData updatedAspects = BiomeAspectModifier.getCombinedBiomeAspects(biomeId);
            int newAmount = updatedAspects.getLevel(targetAspect);
            int newVitiumAmount = updatedAspects.getLevel(VITIUM_ID);
            AspectsLib.LOGGER.info("Vitium consumed 1 {} from biome {}. {}: {} -> {}, Vitium: {} -> {}", new Object[]{targetAspect, biomeId, targetAspect, currentAmount, newAmount, previousVitiumAmount, newVitiumAmount});
            if (newAmount <= 0) {
                AspectsLib.LOGGER.info("Aspect {} completely consumed in biome {}! Moving to next aspect.", (Object)targetAspect, (Object)biomeId);
            }
            return Optional.of(new AspectConsumptionResult(targetAspect, currentAmount, newAmount, previousVitiumAmount, newVitiumAmount));
        }
        return Optional.empty();
    }

    private static void processAetherConsumption(class_3218 world, class_1923 chunkPos, class_2960 biomeId, long currentTime) {
        AetherChunkData aetherData = AetherManager.getAetherData((class_1937)world, chunkPos);
        int totalAether = 0;
        for (class_2960 class_29602 : aetherData.getAspectIds()) {
            totalAether += aetherData.getCurrentAether(class_29602);
        }
        if (totalAether > 0) {
            class_2960 targetAspect = null;
            for (class_2960 aspectId : aetherData.getAspectIds()) {
                if (aetherData.getCurrentAether(aspectId) <= 0) continue;
                targetAspect = aspectId;
                if (aspectId.equals((Object)VITIUM_ID)) continue;
                break;
            }
            if (targetAspect != null && aetherData.harvestAether(targetAspect, 1)) {
                BiomeAspectModifier.addBiomeModification(biomeId, VITIUM_ID, 1);
                BiomeAspectModifier.applyModificationsToRegistry();
                CorruptionDataManager.recordAetherConsumption(world, chunkPos, biomeId, targetAspect, 1, currentTime);
                CorruptionDataManager.recordAspectDelta(world, chunkPos, biomeId, VITIUM_ID, 1, currentTime);
                AspectsLib.LOGGER.info("Consumed 1 {} Aether from chunk {}, total aether remaining: {}", new Object[]{targetAspect, chunkPos, totalAether - 1});
            }
        } else if (!AetherManager.isDeadZone((class_1937)world, chunkPos)) {
            boolean permanent = RANDOM.nextDouble() < 0.1;
            DeadZoneData deadZoneData = new DeadZoneData(permanent, world.method_8510());
            AetherManager.markAsDeadZone((class_1937)world, chunkPos, deadZoneData);
            CorruptionManager.eraseAllAspects(biomeId);
            CorruptionDataManager.updateChunkStatus(world, chunkPos, biomeId, CorruptionChunkData.Status.REGENERATING, currentTime);
            AspectsLib.LOGGER.info("Created {} dead zone at {} in biome {}", new Object[]{permanent ? "permanent" : "temporary", chunkPos, biomeId});
        }
    }

    private static void eraseAllAspects(class_2960 biomeId) {
        AspectData currentAspects = BiomeAspectModifier.getCombinedBiomeAspects(biomeId);
        for (class_2960 aspectId : currentAspects.getAspectIds()) {
            int currentAmount = currentAspects.getLevel(aspectId);
            if (currentAmount <= 0) continue;
            BiomeAspectModifier.addBiomeModification(biomeId, aspectId, -currentAmount);
        }
        BiomeAspectModifier.applyModificationsToRegistry();
        AspectsLib.LOGGER.info("Erased all aspects from biome {}", (Object)biomeId);
    }

    private static void updateCorruptionState(class_2960 biomeId, int state, long time) {
        CorruptionState currentState = CORRUPTION_STATES.get(biomeId);
        if (currentState == null || currentState.state != state) {
            CORRUPTION_STATES.put(biomeId, new CorruptionState(state, time));
        } else {
            currentState.lastSeen = time;
        }
    }

    private static Set<class_1923> getLoadedChunks(class_3218 world) {
        HashSet<class_1923> loadedChunks = new HashSet<class_1923>();
        for (class_3222 player : world.method_18456()) {
            class_1923 playerChunk = player.method_31476();
            int viewDistance = world.method_8503().method_3760().method_14568();
            for (int x = -viewDistance; x <= viewDistance; ++x) {
                for (int z = -viewDistance; z <= viewDistance; ++z) {
                    class_1923 chunkPos = new class_1923(playerChunk.field_9181 + x, playerChunk.field_9180 + z);
                    if (!world.method_14178().method_12123(chunkPos.field_9181, chunkPos.field_9180)) continue;
                    loadedChunks.add(chunkPos);
                }
            }
        }
        return loadedChunks;
    }

    public static int getCorruptionState(class_2960 biomeId) {
        CorruptionState state = CORRUPTION_STATES.get(biomeId);
        return state != null ? state.state : 0;
    }

    public static boolean isBiomeCorrupted(class_2960 biomeId) {
        return CorruptionManager.getCorruptionState(biomeId) == 2;
    }

    public static boolean isBiomeTainted(class_2960 biomeId) {
        return CorruptionManager.getCorruptionState(biomeId) == 1;
    }

    public static boolean isBiomePure(class_2960 biomeId) {
        return CorruptionManager.getCorruptionState(biomeId) == 0;
    }

    private static class CorruptionState {
        static final int PURE = 0;
        static final int TAINTED = 1;
        static final int CORRUPTED = 2;
        int state;
        long lastSeen;

        CorruptionState(int state, long lastSeen) {
            this.state = state;
            this.lastSeen = lastSeen;
        }
    }

    private record AspectConsumptionResult(class_2960 aspectId, int previousAmount, int newAmount, int vitiumBefore, int vitiumAfter) {
    }
}

