/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.overgrown.aspectslib.data.ModRegistries;
import dev.overgrown.aspectslib.networking.PacketCodec;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public record Aspect(String name, class_2960 textureLocation) {
    private final class_2960 textureLocation;
    public static final Codec<Aspect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Aspect::name), (App)class_2960.field_25139.optionalFieldOf("texture_location", (Object)new class_2960("aspectslib", "empty")).forGetter(Aspect::textureLocation)).apply((Applicative)instance, Aspect::new));
    public static final PacketCodec<Aspect> PACKET_CODEC = new PacketCodec<Aspect>(){

        @Override
        public Aspect decode(class_2540 buf) {
            String name = buf.method_19772();
            class_2960 textureLocation = buf.method_10810();
            return new Aspect(name, textureLocation);
        }

        @Override
        public void encode(class_2540 buf, Aspect value) {
            buf.method_10814(value.name());
            buf.method_10812(value.textureLocation());
        }
    };

    public static Aspect getById(class_2960 id) {
        return ModRegistries.ASPECTS.get(id);
    }

    public class_5250 getTranslatedName() {
        return class_2561.method_48321((String)this.getTranslatableKey(), (String)this.name);
    }

    public String getTranslatableKey() {
        if (this.getIdentifier() != null) {
            return "aspect." + this.getIdentifier().method_12836() + "." + this.getIdentifier().method_12832() + ".name";
        }
        return "aspect.aspectslib." + this.name.toLowerCase() + ".name";
    }

    private class_2960 getIdentifier() {
        for (Map.Entry<class_2960, Aspect> entry : ModRegistries.ASPECTS.entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        return null;
    }

    public class_2960 textureLocation() {
        if (!this.textureLocation.equals((Object)new class_2960("aspectslib", "empty"))) {
            return this.textureLocation;
        }
        if (this.getIdentifier() != null) {
            return new class_2960(this.getIdentifier().method_12836(), "textures/aspects_icons/" + this.getIdentifier().method_12832() + ".png");
        }
        return new class_2960("aspectslib", "textures/aspects_icons/" + this.name.toLowerCase() + ".png");
    }

    @Override
    @NotNull
    public String toString() {
        return this.name;
    }
}

