/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.codec.CodecUtils;
import dev.overgrown.aspectslib.data.AspectManager;
import dev.overgrown.aspectslib.resonance.ResonanceCalculator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class AspectData {
    public static final AspectData DEFAULT = new AspectData((Object2IntOpenHashMap<class_2960>)new Object2IntOpenHashMap());
    public static final Codec<AspectData> CODEC = CodecUtils.withAlternative(CodecUtils.lazy(AspectData::getBaseCodec), AspectData.getInlineCodec().xmap(AspectData::new, data -> data.aspects));
    private final Object2IntOpenHashMap<class_2960> aspects;

    private static Codec<Object2IntOpenHashMap<class_2960>> getInlineCodec() {
        return Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.INT).xmap(Object2IntOpenHashMap::new, Function.identity());
    }

    public AspectData(Map<class_2960, Integer> aspects) {
        this.aspects = new Object2IntOpenHashMap();
        this.aspects.putAll(aspects);
    }

    private static Codec<AspectData> getBaseCodec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)AspectData.getInlineCodec().fieldOf("aspects").forGetter(component -> component.aspects)).apply((Applicative)instance, AspectData::new));
    }

    public AspectData(Object2IntOpenHashMap<class_2960> aspects) {
        this.aspects = aspects;
    }

    public int getLevel(class_2960 aspectId) {
        return this.aspects.getInt((Object)aspectId);
    }

    public int getLevelByName(String aspectName) {
        class_2960 aspectId = AspectManager.NAME_TO_ID.get(aspectName);
        return aspectId != null ? this.aspects.getInt((Object)aspectId) : 0;
    }

    public Set<class_2960> getAspectIds() {
        return Collections.unmodifiableSet(this.aspects.keySet());
    }

    public Object2IntOpenHashMap<class_2960> getMap() {
        return this.aspects;
    }

    public int getSize() {
        return this.aspects.size();
    }

    public boolean isEmpty() {
        return this.aspects.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AspectData) {
            AspectData other = (AspectData)o;
            return this.aspects.equals(other.aspects);
        }
        return false;
    }

    public String toString() {
        return "AspectData{aspects=" + String.valueOf(this.aspects) + "}";
    }

    public AspectData addAspect(AspectData aspectData) {
        for (Object2IntMap.Entry aspectIntegerEntry : aspectData.aspects.object2IntEntrySet()) {
            this.aspects.put((Object)((class_2960)aspectIntegerEntry.getKey()), this.aspects.getOrDefault(aspectIntegerEntry.getKey(), 0) + aspectIntegerEntry.getIntValue());
        }
        return this;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).resultOrPartial(arg_0 -> ((Logger)AspectsLib.LOGGER).error(arg_0)).ifPresent(element -> nbt.method_10566("AspectData", element));
        return nbt;
    }

    public static AspectData fromNbt(class_2487 nbt) {
        if (nbt.method_10573("AspectData", 10)) {
            return CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("AspectData")).resultOrPartial(arg_0 -> ((Logger)AspectsLib.LOGGER).error(arg_0)).orElse(DEFAULT);
        }
        return DEFAULT;
    }

    public void toPacket(class_2540 buf) {
        buf.method_10804(this.aspects.size());
        for (Object2IntMap.Entry entry : this.aspects.object2IntEntrySet()) {
            buf.method_10812((class_2960)entry.getKey());
            buf.method_10804(entry.getIntValue());
        }
    }

    public static AspectData fromPacket(class_2540 buf) {
        int size = buf.method_10816();
        Object2IntOpenHashMap aspects = new Object2IntOpenHashMap();
        for (int i = 0; i < size; ++i) {
            class_2960 aspectId = buf.method_10810();
            int amount = buf.method_10816();
            aspects.put((Object)aspectId, amount);
        }
        return new AspectData((Object2IntOpenHashMap<class_2960>)aspects);
    }

    public double calculateTotalRU() {
        double total = 0.0;
        for (Object2IntMap.Entry entry : this.aspects.object2IntEntrySet()) {
            total += (double)entry.getIntValue();
        }
        return total;
    }

    public ResonanceCalculator.ResonanceResult calculateResonance() {
        return ResonanceCalculator.calculate(this);
    }

    public static class Builder {
        private final Object2IntOpenHashMap<class_2960> aspects = new Object2IntOpenHashMap();

        public Builder(AspectData data) {
            this.aspects.putAll(data.aspects);
        }

        public void set(class_2960 aspectId, int level) {
            if (level <= 0) {
                this.aspects.removeInt((Object)aspectId);
            } else {
                this.aspects.put((Object)aspectId, level);
            }
        }

        public void setByName(String aspectName, int level) {
            class_2960 aspectId = AspectManager.NAME_TO_ID.get(aspectName);
            if (aspectId != null) {
                this.set(aspectId, level);
            }
        }

        public void add(class_2960 aspectId, int level) {
            if (level == 0) {
                return;
            }
            int newLevel = this.aspects.getOrDefault((Object)aspectId, 0) + level;
            if (newLevel <= 0) {
                this.aspects.removeInt((Object)aspectId);
            } else {
                this.aspects.put((Object)aspectId, newLevel);
            }
        }

        public void addByName(String aspectName, int level) {
            class_2960 aspectId = AspectManager.NAME_TO_ID.get(aspectName);
            if (aspectId != null) {
                this.add(aspectId, level);
            }
        }

        public void remove(Predicate<class_2960> predicate) {
            this.aspects.keySet().removeIf(predicate);
        }

        public AspectData build() {
            return new AspectData(this.aspects);
        }
    }
}

