/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.data.Aspect;
import dev.overgrown.aspectslib.data.ModRegistries;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class AspectManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new Gson();
    public static Map<String, class_2960> NAME_TO_ID = new HashMap<String, class_2960>();

    public AspectManager() {
        super(GSON, "aspects");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ModRegistries.ASPECTS.clear();
        NAME_TO_ID.clear();
        AtomicInteger loadedCount = new AtomicInteger();
        for (Map.Entry<class_2960, JsonElement> entry : prepared.entrySet()) {
            class_2960 id = entry.getKey();
            JsonElement json = entry.getValue();
            Aspect.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(error -> AspectsLib.LOGGER.error("Failed to parse aspect data {}: {}", (Object)id, error)).ifPresent(aspect -> {
                ModRegistries.ASPECTS.put(id, (Aspect)aspect);
                NAME_TO_ID.put(id.method_12832(), id);
                loadedCount.getAndIncrement();
                AspectsLib.LOGGER.debug("Loaded aspect: {} -> {}", (Object)id.method_12832(), (Object)id);
            });
        }
        AspectsLib.LOGGER.info("Loaded {} aspects from datapacks", (Object)loadedCount);
    }

    public class_2960 getFabricId() {
        return AspectsLib.identifier("aspects");
    }
}

