/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.ItemAspectRegistry;
import dev.overgrown.aspectslib.data.ModRegistries;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5699;

public class CustomItemTagManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new Gson();

    public CustomItemTagManager() {
        super(GSON, "tags/items");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ItemAspectRegistry.reset();
        if (ModRegistries.ASPECTS.isEmpty()) {
            AspectsLib.LOGGER.warn("Aspects map is empty, aspects may not be loaded yet");
            return;
        }
        AspectsLib.LOGGER.info("Processing {} items tag files", (Object)prepared.size());
        prepared.forEach((identifier, jsonElement) -> {
            AspectsLib.LOGGER.debug("Processing items tag: {}", identifier);
            if (identifier.equals((Object)AspectsLib.identifier("aspects"))) {
                AspectsLib.LOGGER.info("Found aspects tag file, processing...");
                if (jsonElement instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    if (class_3518.method_15254((JsonObject)jsonObject, (String)"replace") && class_3518.method_15270((JsonObject)jsonObject, (String)"replace")) {
                        ItemAspectRegistry.reset();
                    }
                    if (class_3518.method_15264((JsonObject)jsonObject, (String)"values")) {
                        JsonArray values = class_3518.method_15261((JsonObject)jsonObject, (String)"values");
                        AspectsLib.LOGGER.info("Processing {} aspect entries", (Object)values.size());
                        for (JsonElement value : values) {
                            if (!(value instanceof JsonObject)) continue;
                            JsonObject jsonItemObject = (JsonObject)value;
                            DataResult id = class_5699.field_39274.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonItemObject.get("id"));
                            if (id.result().isPresent()) {
                                class_5699.class_7476 tagEntry = (class_5699.class_7476)id.result().get();
                                class_2960 itemId = tagEntry.comp_813();
                                AspectsLib.LOGGER.debug("Processing entry: {} (tag: {})", (Object)itemId, (Object)tagEntry.comp_814());
                                if (!jsonItemObject.has("aspects")) continue;
                                Object2IntOpenHashMap aspectAmount = new Object2IntOpenHashMap();
                                JsonObject jsonAspectObject = jsonItemObject.getAsJsonObject("aspects");
                                for (String aspectID : jsonAspectObject.asMap().keySet()) {
                                    class_2960 aspectIdentifier = new class_2960(aspectID);
                                    if (ModRegistries.ASPECTS.containsKey(aspectIdentifier)) {
                                        int amount = class_3518.method_15260((JsonObject)jsonAspectObject, (String)aspectID);
                                        aspectAmount.put((Object)aspectIdentifier, amount);
                                        AspectsLib.LOGGER.debug("Added aspect {} with amount {} to items {}", new Object[]{aspectID, amount, itemId});
                                        continue;
                                    }
                                    AspectsLib.LOGGER.warn("Could not find aspect: {}", (Object)aspectID);
                                }
                                if (aspectAmount.isEmpty()) continue;
                                ItemAspectRegistry.register(itemId, new AspectData((Object2IntOpenHashMap<class_2960>)aspectAmount));
                                AspectsLib.LOGGER.debug("Registered {} aspects for items: {}", (Object)aspectAmount.size(), (Object)itemId);
                                continue;
                            }
                            AspectsLib.LOGGER.warn("Failed to parse items ID from: {}", (Object)jsonItemObject.get("id"));
                        }
                    }
                } else {
                    AspectsLib.LOGGER.warn("aspects.json is not a valid JSON object");
                }
            }
        });
        AspectsLib.LOGGER.info("Finished loading aspects from items tags. Registry contains {} items aspects.", (Object)ItemAspectRegistry.size());
    }

    public class_2960 getFabricId() {
        return AspectsLib.identifier("item_aspects");
    }

    public Collection<class_2960> getFabricDependencies() {
        return List.of(AspectsLib.identifier("aspects"));
    }
}

