/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.data;

import dev.overgrown.aspectslib.data.AspectData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ItemAspectRegistry {
    private static final HashMap<class_2960, AspectData> idToAspect = new HashMap();
    private static final HashMap<class_2960, AspectData> tagToAspect = new HashMap();

    public static AspectData register(class_2960 id, AspectData aspect) {
        idToAspect.put(id, aspect);
        return aspect;
    }

    public static void update(class_2960 id, AspectData aspect) {
        if (idToAspect.containsKey(id)) {
            AspectData old = idToAspect.get(id);
            idToAspect.remove(id);
        }
        ItemAspectRegistry.register(id, aspect);
    }

    protected static void remove(class_2960 id) {
        idToAspect.remove(id);
    }

    public static int size() {
        return idToAspect.size();
    }

    public static Stream<class_2960> identifiers() {
        return idToAspect.keySet().stream();
    }

    public static Set<Map.Entry<class_2960, AspectData>> entries() {
        return idToAspect.entrySet();
    }

    public static List<AspectData> values() {
        return idToAspect.values().stream().toList();
    }

    public static AspectData get(class_2960 id) {
        AspectData direct = idToAspect.get(id);
        if (direct != null) {
            return direct;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
        if (item != null && item != class_1802.field_8162) {
            for (Map.Entry<class_2960, AspectData> tagEntry : tagToAspect.entrySet()) {
                class_6862 itemTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagEntry.getKey());
                try {
                    if (!item.method_7854().method_31573(itemTag)) continue;
                    return tagEntry.getValue();
                }
                catch (Exception exception) {
                }
            }
        }
        return AspectData.DEFAULT;
    }

    public static void registerTag(class_2960 tagId, AspectData aspect) {
        tagToAspect.put(tagId, aspect);
    }

    public static class_2960 getId(AspectData aspect) {
        Optional<Map.Entry> entryOptional = idToAspect.entrySet().stream().filter(aspectEntry -> Objects.equals(aspectEntry.getValue(), aspect)).findFirst();
        if (entryOptional.isPresent()) {
            return (class_2960)entryOptional.get().getKey();
        }
        throw new IllegalArgumentException("Could not get identifier from aspect data '" + aspect.toString() + "', as it was not registered!");
    }

    public static boolean contains(class_2960 id) {
        return idToAspect.containsKey(id);
    }

    public static void clear() {
        idToAspect.clear();
        tagToAspect.clear();
    }

    public static void reset() {
        ItemAspectRegistry.clear();
    }

    public static int tagSize() {
        return tagToAspect.size();
    }

    public static Set<class_2960> getRegisteredTags() {
        return new HashSet<class_2960>(tagToAspect.keySet());
    }
}

