/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.BiomeAspectRegistry;
import dev.overgrown.aspectslib.data.BlockAspectRegistry;
import dev.overgrown.aspectslib.data.EntityAspectRegistry;
import dev.overgrown.aspectslib.data.ItemAspectRegistry;
import dev.overgrown.aspectslib.data.ModRegistries;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class UniversalAspectManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new Gson();

    public UniversalAspectManager() {
        super(GSON, "aspect_assignments");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ItemAspectRegistry.clear();
        BlockAspectRegistry.clear();
        EntityAspectRegistry.clear();
        BiomeAspectRegistry.clear();
        if (ModRegistries.ASPECTS.isEmpty()) {
            AspectsLib.LOGGER.warn("Aspects map is empty, aspects may not be loaded yet");
            return;
        }
        AspectsLib.LOGGER.info("Processing {} aspect assignment files", (Object)prepared.size());
        for (Map.Entry<class_2960, JsonElement> entry : prepared.entrySet()) {
            class_2960 fileId = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            AspectsLib.LOGGER.debug("Processing aspect assignment file: {}", (Object)fileId);
            if (jsonElement instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonElement;
                for (JsonElement element : jsonArray) {
                    if (!(element instanceof JsonObject)) continue;
                    JsonObject assignment = (JsonObject)element;
                    this.processAssignment(assignment);
                }
                continue;
            }
            AspectsLib.LOGGER.warn("Aspect assignment file {} is not a JSON array", (Object)fileId);
        }
        AspectsLib.LOGGER.info("Finished loading universal aspect assignments");
    }

    private void processAssignment(JsonObject assignment) {
        if (!assignment.has("aspects")) {
            AspectsLib.LOGGER.warn("Assignment missing 'aspects' field");
            return;
        }
        Object2IntOpenHashMap<class_2960> aspects = this.parseAspects(assignment.getAsJsonObject("aspects"));
        if (aspects.isEmpty()) {
            return;
        }
        AspectData aspectData = new AspectData(aspects);
        if (assignment.has("item")) {
            String itemId = class_3518.method_15265((JsonObject)assignment, (String)"item");
            class_2960 id = new class_2960(itemId);
            ItemAspectRegistry.register(id, aspectData);
        } else if (assignment.has("item_tag")) {
            String tagId = class_3518.method_15265((JsonObject)assignment, (String)"item_tag");
            if (tagId.startsWith("#")) {
                tagId = tagId.substring(1);
            }
            class_2960 tagIdentifier = new class_2960(tagId);
            ItemAspectRegistry.registerTag(tagIdentifier, aspectData);
        } else if (assignment.has("block")) {
            String blockId = class_3518.method_15265((JsonObject)assignment, (String)"block");
            BlockAspectRegistry.register(new class_2960(blockId), aspectData);
        } else if (assignment.has("block_tag")) {
            String tagId = class_3518.method_15265((JsonObject)assignment, (String)"block_tag");
            if (tagId.startsWith("#")) {
                tagId = tagId.substring(1);
            }
            BlockAspectRegistry.register(new class_2960(tagId), aspectData);
        } else if (assignment.has("entity")) {
            String entityId = class_3518.method_15265((JsonObject)assignment, (String)"entity");
            EntityAspectRegistry.register(new class_2960(entityId), aspectData);
        } else if (assignment.has("entity_tag")) {
            String tagId = class_3518.method_15265((JsonObject)assignment, (String)"entity_tag");
            if (tagId.startsWith("#")) {
                tagId = tagId.substring(1);
            }
            EntityAspectRegistry.register(new class_2960(tagId), aspectData);
        } else if (assignment.has("biome")) {
            String biomeId = class_3518.method_15265((JsonObject)assignment, (String)"biome");
            class_2960 id = new class_2960(biomeId);
            class_5321 biomeKey = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)id);
            BiomeAspectRegistry.register((class_5321<class_1959>)biomeKey, aspectData);
        } else if (assignment.has("biome_tag")) {
            String tagId = class_3518.method_15265((JsonObject)assignment, (String)"biome_tag");
            if (tagId.startsWith("#")) {
                tagId = tagId.substring(1);
            }
            BiomeAspectRegistry.register(new class_2960(tagId), aspectData);
        } else {
            AspectsLib.LOGGER.warn("Assignment has no valid target (item, item_tag, block, block_tag, entity, entity_tag, biome, biome_tag)");
        }
    }

    private Object2IntOpenHashMap<class_2960> parseAspects(JsonObject aspectsJson) {
        Object2IntOpenHashMap aspects = new Object2IntOpenHashMap();
        for (Map.Entry entry : aspectsJson.asMap().entrySet()) {
            String aspectId = (String)entry.getKey();
            JsonElement valueElement = (JsonElement)entry.getValue();
            if (valueElement.isJsonPrimitive() && valueElement.getAsJsonPrimitive().isNumber()) {
                class_2960 aspectIdentifier = new class_2960(aspectId);
                if (ModRegistries.ASPECTS.containsKey(aspectIdentifier)) {
                    int amount = valueElement.getAsInt();
                    aspects.put((Object)aspectIdentifier, amount);
                    AspectsLib.LOGGER.debug("Added aspect {} with amount {}", (Object)aspectId, (Object)amount);
                    continue;
                }
                AspectsLib.LOGGER.warn("Unknown aspect: {}", (Object)aspectId);
                continue;
            }
            AspectsLib.LOGGER.warn("Invalid aspect amount for {}: {}", (Object)aspectId, (Object)valueElement);
        }
        return aspects;
    }

    public class_2960 getFabricId() {
        return AspectsLib.identifier("universal_aspects");
    }

    public Collection<class_2960> getFabricDependencies() {
        return List.of(AspectsLib.identifier("aspects"));
    }
}

