/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.recipe;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.overgrown.aspectslib.AspectsLib;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class RecipeAspectConfig {
    private static final Path CONFIG_PATH = Paths.get("config", "aspectslib", "recipe_aspects.json");
    private boolean enabled = true;
    private double craftingLoss = 0.8;
    private double smeltingLoss = 0.9;
    private double smithingLoss = 0.95;
    private double stonecuttingLoss = 1.0;
    private int maxDepth = 20;
    private int parallelThreads = 4;
    private boolean preferLowestValueIngredient = true;
    private boolean debugLogging = false;
    private static RecipeAspectConfig INSTANCE;

    public static RecipeAspectConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RecipeAspectConfig();
            INSTANCE.load();
        }
        return INSTANCE;
    }

    public void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String content = Files.readString(CONFIG_PATH);
                JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
                if (json.has("enabled")) {
                    this.enabled = json.get("enabled").getAsBoolean();
                }
                if (json.has("craftingLoss")) {
                    this.craftingLoss = json.get("craftingLoss").getAsDouble();
                }
                if (json.has("smeltingLoss")) {
                    this.smeltingLoss = json.get("smeltingLoss").getAsDouble();
                }
                if (json.has("smithingLoss")) {
                    this.smithingLoss = json.get("smithingLoss").getAsDouble();
                }
                if (json.has("stonecuttingLoss")) {
                    this.stonecuttingLoss = json.get("stonecuttingLoss").getAsDouble();
                }
                if (json.has("maxDepth")) {
                    this.maxDepth = json.get("maxDepth").getAsInt();
                }
                if (json.has("parallelThreads")) {
                    this.parallelThreads = json.get("parallelThreads").getAsInt();
                }
                if (json.has("preferLowestValueIngredient")) {
                    this.preferLowestValueIngredient = json.get("preferLowestValueIngredient").getAsBoolean();
                }
                if (json.has("debugLogging")) {
                    this.debugLogging = json.get("debugLogging").getAsBoolean();
                }
                AspectsLib.LOGGER.info("Loaded recipe aspect configuration");
            }
            catch (IOException e) {
                AspectsLib.LOGGER.error("Failed to load recipe aspect config", (Throwable)e);
                this.save();
            }
        } else {
            this.save();
        }
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("craftingLoss", (Number)this.craftingLoss);
            json.addProperty("smeltingLoss", (Number)this.smeltingLoss);
            json.addProperty("smithingLoss", (Number)this.smithingLoss);
            json.addProperty("stonecuttingLoss", (Number)this.stonecuttingLoss);
            json.addProperty("maxDepth", (Number)this.maxDepth);
            json.addProperty("parallelThreads", (Number)this.parallelThreads);
            json.addProperty("preferLowestValueIngredient", Boolean.valueOf(this.preferLowestValueIngredient));
            json.addProperty("debugLogging", Boolean.valueOf(this.debugLogging));
            String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
            Files.writeString(CONFIG_PATH, (CharSequence)jsonString, new OpenOption[0]);
            AspectsLib.LOGGER.info("Saved recipe aspect configuration");
        }
        catch (IOException e) {
            AspectsLib.LOGGER.error("Failed to save recipe aspect config", (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getCraftingLoss() {
        return this.craftingLoss;
    }

    public double getSmeltingLoss() {
        return this.smeltingLoss;
    }

    public double getSmithingLoss() {
        return this.smithingLoss;
    }

    public double getStonecuttingLoss() {
        return this.stonecuttingLoss;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getParallelThreads() {
        return this.parallelThreads;
    }

    public boolean isPreferLowestValueIngredient() {
        return this.preferLowestValueIngredient;
    }

    public boolean isDebugLogging() {
        return this.debugLogging;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.save();
    }
}

