/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.recipe;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.recipe.RecipeAspectCalculator;
import dev.overgrown.aspectslib.recipe.RecipeAspectConfig;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.server.MinecraftServer;

public class RecipeAspectManager
implements IdentifiableResourceReloadListener {
    private static RecipeAspectManager INSTANCE;
    private MinecraftServer server;
    private RecipeAspectCalculator calculator;
    private final RecipeAspectConfig config;

    public RecipeAspectManager() {
        INSTANCE = this;
        this.config = RecipeAspectConfig.getInstance();
    }

    public static RecipeAspectManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RecipeAspectManager();
        }
        return INSTANCE;
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
        if (server != null) {
            this.calculator = new RecipeAspectCalculator(server);
        }
    }

    public void setEnabled(boolean enabled) {
        this.config.setEnabled(enabled);
        AspectsLib.LOGGER.info("Recipe aspect calculation {}", (Object)(enabled ? "enabled" : "disabled"));
    }

    public void recalculateAspects() {
        if (this.server == null || this.calculator == null) {
            AspectsLib.LOGGER.warn("Cannot calculate recipe aspects: server not initialized");
            return;
        }
        if (!this.config.isEnabled()) {
            AspectsLib.LOGGER.info("Recipe aspect calculation is disabled");
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.calculator.calculateAllAspects();
            }
            catch (Exception e) {
                AspectsLib.LOGGER.error("Failed to calculate recipe aspects", (Throwable)e);
            }
        });
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return synchronizer.method_18352(null).thenRunAsync(() -> {
            applyProfiler.method_16065();
            applyProfiler.method_15396("aspectslib:recipe_aspects");
            if (this.server != null && this.config.isEnabled()) {
                AspectsLib.LOGGER.info("Triggering recipe aspect recalculation after resource reload");
                this.recalculateAspects();
            }
            applyProfiler.method_15407();
            applyProfiler.method_16066();
        }, applyExecutor);
    }

    public class_2960 getFabricId() {
        return AspectsLib.identifier("recipe_aspects");
    }

    public Collection<class_2960> getFabricDependencies() {
        return List.of(AspectsLib.identifier("aspects"), AspectsLib.identifier("universal_aspects"), new class_2960("minecraft", "recipes"), new class_2960("minecraft", "tags/items"));
    }

    public static void initialize() {
        RecipeAspectManager manager = RecipeAspectManager.getInstance();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            manager.setServer(server);
            AspectsLib.LOGGER.info("Recipe aspect manager initialized with server");
            server.execute(() -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                AspectsLib.LOGGER.info("Starting delayed recipe aspect calculation...");
                manager.recalculateAspects();
            });
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> manager.setServer(null));
    }
}

