/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.resonance;

import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.resonance.Resonance;
import dev.overgrown.aspectslib.resonance.ResonanceManager;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;

public class ResonanceCalculator {
    public static ResonanceResult calculate(AspectData data) {
        double totalRU = 0.0;
        double amplificationFactor = 1.0;
        double barrierCost = 0.0;
        Object2IntOpenHashMap<class_2960> aspects = data.getMap();
        for (Map.Entry entry : aspects.entrySet()) {
            class_2960 aspectId = (class_2960)entry.getKey();
            int amount = (Integer)entry.getValue();
            List resonances = ResonanceManager.RESONANCE_MAP.getOrDefault(aspectId, Collections.emptyList());
            for (Resonance resonance : resonances) {
                class_2960 otherId;
                if (resonance == null || !aspects.containsKey(otherId = resonance.aspect1().equals((Object)aspectId) ? resonance.aspect2() : resonance.aspect1())) continue;
                int otherAmount = (Integer)aspects.get(otherId);
                if (resonance.type() == Resonance.Type.AMPLIFYING) {
                    double boost = (double)(amount + otherAmount) / 2.0 * resonance.factor();
                    amplificationFactor += boost;
                    totalRU += boost;
                    continue;
                }
                double barrier = (double)Math.min(amount, otherAmount) * resonance.factor();
                barrierCost += barrier;
                totalRU -= barrier;
            }
        }
        return new ResonanceResult(totalRU, amplificationFactor, barrierCost);
    }

    public record ResonanceResult(double totalRU, double amplificationFactor, double barrierCost) {
    }
}

