package dev.overgrown.aspectslib.aether;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class AetherDensity {
    public static final AetherDensity EMPTY = new AetherDensity(Collections.emptyMap());
    private final Map<class_2960, Double> densities;

    public AetherDensity(Map<class_2960, Double> densities) {
        this.densities = Map.copyOf(densities);
    }

    public double getDensity(class_2960 aspect) {
        return densities.getOrDefault(aspect, 0.0);
    }

    public Map<class_2960, Double> getDensities() {
        return Collections.unmodifiableMap(densities);
    }

    public static AetherDensity fromJson(JsonObject json) {
        Map<class_2960, Double> densityMap = new HashMap<>();
        for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
            class_2960 aspectId = new class_2960(entry.getKey());
            double density = entry.getValue().getAsDouble();
            densityMap.put(aspectId, density);
        }
        return new AetherDensity(densityMap);
    }
}