package dev.overgrown.aspectslib.aether;

import dev.overgrown.aspectslib.AspectsLib;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class AetherDensityManager {
    public static AetherDensity getDensity(class_1937 world, class_2338 pos) {
        class_6880<class_1959> biomeEntry = world.method_23753(pos);
        class_2960 biomeId = null;

        if (biomeEntry.method_40230().isPresent()) {
            biomeId = biomeEntry.method_40230().get().method_29177();
        } else if (world instanceof class_3218 serverWorld) {
            biomeId = serverWorld.method_30349()
                    .method_30530(class_7924.field_41236)
                    .method_10221(biomeEntry.comp_349());
        }

        AspectsLib.LOGGER.debug("Getting density for biome: {} at position {}", biomeId, pos);
        AspectsLib.LOGGER.debug("Available biome densities: {}", BiomeAetherDensityManager.DENSITY_MAP.keySet());
        
        AetherDensity density = biomeId != null ?
                BiomeAetherDensityManager.DENSITY_MAP.getOrDefault(biomeId, AetherDensity.EMPTY) :
                AetherDensity.EMPTY;
                
        if (density == AetherDensity.EMPTY && biomeId != null) {
            AspectsLib.LOGGER.debug("No base density found for biome: {}", biomeId);
        } else if (density != AetherDensity.EMPTY) {
            AspectsLib.LOGGER.debug("Found base density for biome {}: {}", biomeId, density.getDensities());
        }
        if (world instanceof class_3218 serverWorld) {
            class_2791 chunk = world.method_22350(pos);
            Map<class_3195, class_3449> structureStarts = chunk.method_12016();

            Map<class_2960, Double> additiveModifiers = new HashMap<>();
            Map<class_2960, Double> multiplicativeModifiers = new HashMap<>();

            for (var entry : structureStarts.entrySet()) {
                class_3195 structure = entry.getKey();
                class_3449 start = entry.getValue();

                if (start != null && start.method_14969() != null && start.method_14969().method_14662(pos)) {
                    class_2960 structureId = world.method_30349().method_30530(class_7924.field_41246).method_10221(structure);
                    if (structureId == null) continue;

                    AetherModifier modifier = StructureAetherModifierManager.MODIFIER_MAP.get(structureId);
                    if (modifier == null) continue;

                    for (var aspectEntry : modifier.modifiers().entrySet()) {
                        class_2960 aspect = aspectEntry.getKey();
                        double value = aspectEntry.getValue();

                        switch (modifier.operation()) {
                            case ADD -> additiveModifiers.merge(aspect, value, Double::sum);
                            case MULTIPLY -> multiplicativeModifiers.merge(aspect,
                                    multiplicativeModifiers.getOrDefault(aspect, 1.0) * value,
                                    (a, b) -> a * b
                            );
                        }
                    }
                }
            }

            Map<class_2960, Double> finalDensities = new HashMap<>(density.getDensities());

            additiveModifiers.forEach((aspect, value) ->
                    finalDensities.merge(aspect, value, Double::sum)
            );

            multiplicativeModifiers.forEach((aspect, value) ->
                    finalDensities.computeIfPresent(aspect, (k, v) -> v * value)
            );

            if (biomeId != null) {
                Map<class_2960, Double> dynamicMods = DynamicAetherDensityManager.getModifications(biomeId);
                if (dynamicMods != null) {
                    for (Map.Entry<class_2960, Double> entry : dynamicMods.entrySet()) {
                        finalDensities.merge(entry.getKey(), entry.getValue(), Double::sum);
                    }
                }
            }

            return new AetherDensity(finalDensities);
        }

        return density;
    }
}