package dev.overgrown.aspectslib.aether;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.overgrown.aspectslib.AspectsLib;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import java.util.HashMap;
import java.util.Map;

public class BiomeAetherDensityManager extends class_4309 implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new Gson();
    public static final Map<class_2960, AetherDensity> DENSITY_MAP = new HashMap<>();

    public BiomeAetherDensityManager() {
        super(GSON, "aether_densities/biome");
    }

    @Override
    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        DENSITY_MAP.clear();
        AspectsLib.LOGGER.info("Starting to load biome aether densities from {} files", prepared.size());
        
        prepared.forEach((resourceId, json) -> {
            try {
                AspectsLib.LOGGER.debug("Processing resource: {}", resourceId);
                
                String path = resourceId.method_12832();
                
                if (path.endsWith(".json")) {
                    path = path.substring(0, path.length() - 5);
                }
                
                class_2960 biomeId;
                
                if (path.contains("/")) {
                    String[] parts = path.split("/");
                    if (parts.length >= 2) {
                        String namespace = parts[0];
                        String biomeName = String.join("/", java.util.Arrays.copyOfRange(parts, 1, parts.length));
                        biomeId = new class_2960(namespace, biomeName);
                    } else {
                        biomeId = new class_2960(resourceId.method_12836(), path);
                    }
                } else {
                    biomeId = new class_2960(resourceId.method_12836(), path);
                }
                
                AspectsLib.LOGGER.info("Loading aether density for biome: {}", biomeId);
                
                JsonObject jsonObj = json.getAsJsonObject();

                JsonObject valuesObj = null;
                if (jsonObj.has("values")) {
                    valuesObj = jsonObj.getAsJsonObject("values");
                } else {
                    valuesObj = jsonObj;
                }

                AetherDensity density = AetherDensity.fromJson(valuesObj);
                DENSITY_MAP.put(biomeId, density);
                
                AspectsLib.LOGGER.info("Successfully loaded {} aspects for biome {}: {}", 
                    density.getDensities().size(), biomeId, density.getDensities());
                    
            } catch (Exception e) {
                AspectsLib.LOGGER.error("Error loading biome aether density from {}: {}", resourceId, e.getMessage(), e);
            }
        });
        
        AspectsLib.LOGGER.info("Completed loading {} biome aether densities", DENSITY_MAP.size());
        
        DENSITY_MAP.forEach((biomeId, density) -> {
            AspectsLib.LOGGER.debug("Biome {} has densities: {}", biomeId, density.getDensities());
        });
    }

    @Override
    public class_2960 getFabricId() {
        return AspectsLib.identifier("biome_aether_density");
    }
}