package dev.overgrown.aspectslib.aether;

import dev.overgrown.aspectslib.AspectsLib;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7124;

public class CorruptionManager {
    private static final Map<class_2960, List<CorruptionSource>> CORRUPTION_SOURCES = new ConcurrentHashMap<>();
    private static final class_2960 VITIUM_ASPECT = AspectsLib.identifier("vitium");

    public static void addCorruptionSource(class_2960 biomeId, class_2338 pos, int strength) {
        CORRUPTION_SOURCES.computeIfAbsent(biomeId, k -> new ArrayList<>())
                .add(new CorruptionSource(pos, strength));
    }

    public static void tick(class_3218 world) {
        for (Map.Entry<class_2960, List<CorruptionSource>> entry : CORRUPTION_SOURCES.entrySet()) {
            class_2960 biomeId = entry.getKey();
            List<CorruptionSource> sources = entry.getValue();

            // Get base biome density
            AetherDensity baseDensity = BiomeAetherDensityManager.DENSITY_MAP.getOrDefault(biomeId, AetherDensity.EMPTY);

            // Get current modifications
            Map<class_2960, Double> modifications = DynamicAetherDensityManager.getModifications(biomeId);
            if (modifications == null) {
                modifications = new HashMap<>();
            }

            // Calculate total vitium (base + modifications)
            double totalVitium = baseDensity.getDensity(VITIUM_ASPECT) +
                    modifications.getOrDefault(VITIUM_ASPECT, 0.0);

            // Calculate total other aspects (base + modifications)
            double totalOtherAspects = 0;
            for (Map.Entry<class_2960, Double> baseEntry : baseDensity.getDensities().entrySet()) {
                if (!baseEntry.getKey().equals(VITIUM_ASPECT)) {
                    totalOtherAspects += baseEntry.getValue() +
                            modifications.getOrDefault(baseEntry.getKey(), 0.0);
                }
            }

            // Add other aspects that are only in modifications but not in base
            for (Map.Entry<class_2960, Double> modEntry : modifications.entrySet()) {
                if (!modEntry.getKey().equals(VITIUM_ASPECT) &&
                        !baseDensity.getDensities().containsKey(modEntry.getKey())) {
                    totalOtherAspects += modEntry.getValue();
                }
            }

            // Only start corruption if vitium is dominant
            if (totalVitium > totalOtherAspects) {
                // If vitium is dominant, convert other aspects to vitium
                for (Map.Entry<class_2960, Double> aspectEntry : modifications.entrySet()) {
                    if (aspectEntry.getKey().equals(VITIUM_ASPECT)) {
                        continue;
                    }
                    double convertedAmount = aspectEntry.getValue() * 0.1; // Convert 10% per check
                    DynamicAetherDensityManager.addModification(
                            biomeId,
                            aspectEntry.getKey(),
                            -convertedAmount
                    );
                    DynamicAetherDensityManager.addModification(
                            biomeId,
                            VITIUM_ASPECT,
                            convertedAmount
                    );
                }

                // Replace random blocks with sculk from each source when vitium is dominant
                for (CorruptionSource source : sources) {
                    if (world.method_8409().method_43057() < 0.1f) { // 10% chance per source per tick
                        replaceRandomBlockWithSculk(world, source.position);
                    }
                }
            }
        }
    }

    private static void replaceRandomBlockWithSculk(class_1937 world, class_2338 centerPos) {
        // Get a random position within 16 blocks
        class_2338 targetPos = centerPos.method_10069(
                world.field_9229.method_43048(32) - 16,
                world.field_9229.method_43048(8) - 4,
                world.field_9229.method_43048(32) - 16
        );

        // Check if the block is replaceable
        if (!world.method_8320(targetPos).method_26215() &&
                !(world.method_8320(targetPos).method_26204() instanceof class_7124)) {
            // Replace with sculk block
            world.method_8501(targetPos, class_2246.field_37568.method_9564());

            // Visual and sound effects
            if (world instanceof class_3218 serverWorld) {
                serverWorld.method_14199(class_2398.field_23114,
                        targetPos.method_10263() + 0.5, targetPos.method_10264() + 0.5, targetPos.method_10260() + 0.5,
                        5, 0.2, 0.2, 0.2, 0.0);
                world.method_8396(null, targetPos, class_3417.field_37362,
                        class_3419.field_15245, 1.0f, 1.0f);
            }
        }
    }

    private static class CorruptionSource {
        public final class_2338 position;
        public final int strength;

        public CorruptionSource(class_2338 position, int strength) {
            this.position = position;
            this.strength = strength;
        }
    }
}