package dev.overgrown.aspectslib.aether;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;

public class DynamicAetherDensityManager {
    private static final Map<class_2960, Map<class_2960, Double>> modifications = new ConcurrentHashMap<>();

    public static void addModification(class_2960 biomeId, class_2960 aspect, double amount) {
        modifications.computeIfAbsent(biomeId, k -> new ConcurrentHashMap<>())
                .merge(aspect, amount, Double::sum);
    }

    public static void drainAllAspects(class_2960 biomeId, double amount) {
        Map<class_2960, Double> biomeMods = modifications.get(biomeId);
        if (biomeMods != null) {
            biomeMods.replaceAll((aspect, current) -> current - amount);
        }
    }

    public static double getModification(class_2960 biomeId, class_2960 aspect) {
        Map<class_2960, Double> biomeMods = modifications.get(biomeId);
        return biomeMods != null ? biomeMods.getOrDefault(aspect, 0.0) : 0.0;
    }

    public static Map<class_2960, Double> getModifications(class_2960 biomeId) {
        return modifications.get(biomeId);
    }

    public static void reset() {
        modifications.clear();
    }
}