package dev.overgrown.aspectslib.aether;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.overgrown.aspectslib.AspectsLib;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import java.util.HashMap;
import java.util.Map;

public class StructureAetherModifierManager extends class_4309 implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new Gson();
    public static final Map<class_2960, AetherModifier> MODIFIER_MAP = new HashMap<>();

    public StructureAetherModifierManager() {
        super(GSON, "aether_densities/structure");
    }

    @Override
    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        MODIFIER_MAP.clear();
        prepared.forEach((resourceId, json) -> {
            try {
                String path = resourceId.method_12832();
                // Extract structure ID directly from the resource path
                String structurePath = path.replace("aether_densities/structure/", "");
                if (structurePath.isEmpty()) {
                    AspectsLib.LOGGER.warn("Empty structure path in resource: {}", resourceId);
                    return;
                }

                // Remove .json if present
                if (structurePath.endsWith(".json")) {
                    structurePath = structurePath.substring(0, structurePath.length() - 5);
                }

                class_2960 structureId = new class_2960(resourceId.method_12836(), structurePath);
                JsonObject jsonObj = json.getAsJsonObject();
                AetherModifier modifier = AetherModifier.fromJson(jsonObj);
                MODIFIER_MAP.put(structureId, modifier);
            } catch (Exception e) {
                AspectsLib.LOGGER.error("Error loading structure modifier: {}", e.getMessage());
            }
        });
        AspectsLib.LOGGER.info("Loaded {} structure aether modifiers", MODIFIER_MAP.size());
    }

    @Override
    public class_2960 getFabricId() {
        return AspectsLib.identifier("structure_aether_modifier");
    }
}