package dev.overgrown.aspectslib.client;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class AspectsTooltipConfig {
    private static final List<BiPredicate<class_1799, class_1657>> visibilityConditions = new ArrayList<>();
    private static boolean alwaysShow = false;

    static {
        // Default condition: never show unless conditions are added.
        visibilityConditions.add((stack, player) -> alwaysShow);
    }

    public static void addVisibilityCondition(BiPredicate<class_1799, class_1657> condition) {
        visibilityConditions.add(condition);
    }

    public static void setAlwaysShow(boolean alwaysShow) {
        AspectsTooltipConfig.alwaysShow = alwaysShow;
    }

    public static boolean shouldShowTooltip(class_1799 stack, @Nullable class_1657 player) {
        return visibilityConditions.stream().anyMatch(condition -> condition.test(stack, player));
    }
}