package dev.overgrown.aspectslib.client.tooltip;

import dev.overgrown.aspectslib.data.Aspect;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.ModRegistries;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5684;
import net.minecraft.class_757;

/**
 * Renders aspect information in item tooltips.
 * <p>
 * Features:
 * <li>Shows icons and amounts</li>
 * <li>Toggle between names/values with SHIFT</li>
 * <li>Dynamic sizing</li>
 */
public class AspectTooltipComponent implements class_5684 {
    private final AspectData aspectData;

    public AspectTooltipComponent(AspectTooltipData data) {
        this.aspectData = data.aspectData();
    }

    /** Check if it should show aspect names */
    private boolean shouldShowNames() {
        class_310 client = class_310.method_1551();
        return client.field_1755 != null && class_437.method_25442();
    }

    @Override
    public int method_32661() {
        return 18; // Fixed height per line
    }

    @Override
    public int method_32664(class_327 textRenderer) {
        boolean showNames = shouldShowNames();
        int width = 0;
        for (Object2IntMap.Entry<class_2960> entry : aspectData.getMap().object2IntEntrySet()) {
            class_2960 aspectId = entry.getKey();
            Aspect aspect = ModRegistries.ASPECTS.get(aspectId);
            if (aspect == null) continue;

            int valueWidth = showNames ?
                    textRenderer.method_27525(aspect.getTranslatedName()) :
                    textRenderer.method_1727(String.valueOf(entry.getIntValue()));
            width += 16 + 2 + valueWidth + 4;
        }
        return width;
    }

    @Override
    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        boolean showNames = shouldShowNames();
        int currentX = x;
        final int TEXT_COLOR = 0xFFFFFFFF;

        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);

        for (Object2IntMap.Entry<class_2960> entry : aspectData.getMap().object2IntEntrySet()) {
            int value = entry.getIntValue();
            class_2960 aspectId = entry.getKey();

            Aspect aspect = ModRegistries.ASPECTS.get(aspectId);
            if (aspect == null) continue;

            class_2960 texture = aspect.textureLocation();

            // Draw aspect icon
            RenderSystem.setShaderTexture(0, texture);
            context.method_25290(texture, currentX, y, 0, 0, 16, 16, 16, 16);

            int textY = y + 5;

            // Draw text (name or value)
            if (showNames) {
                class_2561 aspectName = aspect.getTranslatedName().method_27692(class_124.field_1068);
                context.method_51439(textRenderer, aspectName, currentX + 18, textY, TEXT_COLOR, false);
                currentX += 16 + textRenderer.method_27525(aspectName) + 6;
            } else {
                String valueStr = String.valueOf(value);
                context.method_51433(textRenderer, valueStr, currentX + 18, textY, TEXT_COLOR, false);
                currentX += 16 + textRenderer.method_1727(valueStr) + 6;
            }
        }
    }
}