package dev.overgrown.aspectslib.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

/**
 * Codec for RegistryEntry serialization (currently unused in AspectsLib).
 * <p>
 * Provided as utility for possible future use.
 * </p>
 */
public class RegistryEntryCodec<T> implements Codec<class_6880<T>> {
    private final class_2378<T> registry;

    public RegistryEntryCodec(class_2378<T> registry) {
        this.registry = registry;
    }

    @Override
    public <S> DataResult<Pair<class_6880<T>, S>> decode(DynamicOps<S> ops, S input) {
        return class_2960.field_25139.decode(ops, input).flatMap(idPair -> {
            class_2960 id = idPair.getFirst();
            class_5321<T> key = class_5321.method_29179(registry.method_30517(), id);
            
            return registry.method_40264(key)
                    .<DataResult<Pair<class_6880<T>, S>>>map(entry ->
                            DataResult.success(Pair.of((class_6880<T>) entry, idPair.getSecond()))
                    )
                    .orElseGet(() -> {
                        T value = registry.method_10223(id);
                        if (value != null) {
                            return registry.method_40265(registry.method_10206(value))
                                    .<DataResult<Pair<class_6880<T>, S>>>map(entry ->
                                            DataResult.success(Pair.of((class_6880<T>) entry, idPair.getSecond()))
                                    )
                                    .orElseGet(() -> {
                                        class_6880<T> entry = class_6880.method_40223(value);
                                        return DataResult.success(Pair.of(entry, idPair.getSecond()));
                                    });
                        }
                        return DataResult.error(() -> "Unknown registry key: " + id);
                    });
        });
    }

    @Override
    public <S> DataResult<S> encode(class_6880<T> input, DynamicOps<S> ops, S prefix) {
        return input.method_40230()
                .map(key -> class_2960.field_25139.encode(key.method_29177(), ops, prefix))
                .orElseGet(() -> {
                    if (input.method_40227()) {
                        class_2960 id = registry.method_10221(input.comp_349());
                        if (id != null) {
                            return class_2960.field_25139.encode(id, ops, prefix);
                        }
                    }
                    return DataResult.error(() -> "Registry entry has no key or value");
                });
    }
}