package dev.overgrown.aspectslib.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.aether.AetherDensity;
import dev.overgrown.aspectslib.aether.AetherDensityManager;
import dev.overgrown.aspectslib.aether.BiomeAetherDensityManager;
import dev.overgrown.aspectslib.aether.CorruptionManager;
import dev.overgrown.aspectslib.aether.DynamicAetherDensityManager;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class AetherDensityCommand {
    private static final class_2960 VITIUM_ASPECT = AspectsLib.identifier("vitium");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170.method_9247(AspectsLib.MOD_ID + ":aether_density")
                .requires(source -> source.method_9259(0))
                .executes(AetherDensityCommand::showUsage)
                .then(class_2170.method_9247("report")
                        .executes(AetherDensityCommand::execute))
                .then(class_2170.method_9247("list")
                        .executes(AetherDensityCommand::listDensities))
                .then(class_2170.method_9247("corrupt")
                        .executes(context -> addCorruption(context, 10.0)) // Default to 10 if no argument provided
                        .then(class_2170.method_9244("amount", DoubleArgumentType.doubleArg(0))
                                .executes(context -> addCorruption(context, DoubleArgumentType.getDouble(context, "amount"))))));
    }


    private static int showUsage(CommandContext<class_2168> context) {
        class_2168 source = context.getSource();
        String command = AspectsLib.MOD_ID + ":aether_density";

        if (source.method_9228() instanceof class_3222 player) {
            player.method_43496(class_2561.method_43470("=== Aether Density Command Usage ===").method_27692(class_124.field_1065));
            player.method_43496(class_2561.method_43470("/" + command + " report - Shows a detailed report of the current aether density").method_27692(class_124.field_1054));
            player.method_43496(class_2561.method_43470("/" + command + " list - Lists all loaded biome aether densities").method_27692(class_124.field_1054));
            player.method_43496(class_2561.method_43470("/" + command + " corrupt [<amount>] - Adds vitium corruption to the current biome (default 10)").method_27692(class_124.field_1054));
        } else {
            source.method_45068(class_2561.method_43470("=== Aether Density Command Usage ===").method_27692(class_124.field_1065));
            source.method_45068(class_2561.method_43470("/" + command + " report - Shows a detailed report of the current aether density").method_27692(class_124.field_1054));
            source.method_45068(class_2561.method_43470("/" + command + " list - Lists all loaded biome aether densities").method_27692(class_124.field_1054));
            source.method_45068(class_2561.method_43470("/" + command + " corrupt [<amount>] - Adds vitium corruption to the current biome (default 10)").method_27692(class_124.field_1054));
        }

        return 1;
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2168 source = context.getSource();
        
        if (source.method_9228() instanceof class_3222 player) {
            class_1937 world = player.method_37908();
            class_2338 pos = player.method_24515();

            class_2960 biomeId = world.method_23753(pos).method_40230().orElseThrow().method_29177();
            
            AetherDensity baseDensity = BiomeAetherDensityManager.DENSITY_MAP.get(biomeId);
            
            AetherDensity density = AetherDensityManager.getDensity(world, pos);

            Map<class_2960, Double> modifications = DynamicAetherDensityManager.getModifications(biomeId);

            double vitium = density.getDensity(VITIUM_ASPECT);
            double totalOtherAspects = 0.0;

            for (Map.Entry<class_2960, Double> entry : density.getDensities().entrySet()) {
                if (!entry.getKey().equals(VITIUM_ASPECT)) {
                    totalOtherAspects += entry.getValue();
                }
            }

            player.method_43496(class_2561.method_43470("=== Aether Density Report ===").method_27692(class_124.field_1065));
            player.method_43496(class_2561.method_43470("Position: " + pos.method_23854()).method_27692(class_124.field_1080));
            player.method_43496(class_2561.method_43470("Biome: " + biomeId.toString()).method_27692(class_124.field_1054));
            
            player.method_43496(class_2561.method_43470("---").method_27692(class_124.field_1080));
            player.method_43496(class_2561.method_43470("Debug Info:").method_27692(class_124.field_1076));
            player.method_43496(class_2561.method_43470("  Loaded Biomes: " + BiomeAetherDensityManager.DENSITY_MAP.size()).method_27692(class_124.field_1080));
            player.method_43496(class_2561.method_43470("  Has Base Density: " + (baseDensity != null ? "Yes" : "No")).method_27692(class_124.field_1080));
            
            if (baseDensity != null && !baseDensity.getDensities().isEmpty()) {
                player.method_43496(class_2561.method_43470("---").method_27692(class_124.field_1080));
                player.method_43496(class_2561.method_43470("Base Density (from datapack):").method_27692(class_124.field_1075));
                for (Map.Entry<class_2960, Double> entry : baseDensity.getDensities().entrySet()) {
                    player.method_43496(class_2561.method_43470(
                            String.format("  %s: %.2f", entry.getKey().toString(), entry.getValue())
                    ).method_27692(class_124.field_1080));
                }
            } else {
                player.method_43496(class_2561.method_43470("  No base density found in datapack").method_27692(class_124.field_1061));
            }

            player.method_43496(class_2561.method_43470("---").method_27692(class_124.field_1080));
            player.method_43496(class_2561.method_43470("Final Calculated Density:").method_27692(class_124.field_1060));
            
            if (density.getDensities().isEmpty()) {
                player.method_43496(class_2561.method_43470("  No aspects present").method_27692(class_124.field_1080));
            } else {
                for (Map.Entry<class_2960, Double> entry : density.getDensities().entrySet()) {
                    class_124 color = entry.getKey().equals(VITIUM_ASPECT) ? class_124.field_1061 : class_124.field_1060;
                    player.method_43496(class_2561.method_43470(
                            String.format("  %s: %.2f", entry.getKey().toString(), entry.getValue())
                    ).method_27692(color));
                }
            }

            player.method_43496(class_2561.method_43470("---").method_27692(class_124.field_1080));
            player.method_43496(class_2561.method_43470(String.format("Vitium (Corruption): %.2f", vitium)).method_27692(class_124.field_1061));
            player.method_43496(class_2561.method_43470(String.format("Total Other Aspects: %.2f", totalOtherAspects)).method_27692(class_124.field_1060));

            if (vitium > totalOtherAspects) {
                player.method_43496(class_2561.method_43470("Status: CORRUPTED").method_27692(class_124.field_1079));
            } else {
                player.method_43496(class_2561.method_43470("Status: PURE").method_27692(class_124.field_1077));
            }

            if (modifications != null && !modifications.isEmpty()) {
                player.method_43496(class_2561.method_43470("---").method_27692(class_124.field_1080));
                player.method_43496(class_2561.method_43470("Dynamic Modifications:").method_27692(class_124.field_1078));

                for (Map.Entry<class_2960, Double> entry : modifications.entrySet()) {
                    String change = entry.getValue() >= 0 ? "+" : "";
                    player.method_43496(class_2561.method_43470(
                            String.format("  %s: %s%.2f", entry.getKey().toString(), change, entry.getValue())
                    ));
                }
            }
            
            if (BiomeAetherDensityManager.DENSITY_MAP.isEmpty()) {
                player.method_43496(class_2561.method_43470("---").method_27692(class_124.field_1080));
                player.method_43496(class_2561.method_43470("WARNING: No biome densities loaded from datapacks!").method_27692(class_124.field_1079));
            }

            return 1;
        }

        source.method_9213(class_2561.method_43470("This command can only be used by players"));
        return 0;
    }
    
    private static int listDensities(CommandContext<class_2168> context) {
        class_2168 source = context.getSource();
        
        source.method_45068(class_2561.method_43470("=== Loaded Biome Aether Densities ===").method_27692(class_124.field_1065));
        
        if (BiomeAetherDensityManager.DENSITY_MAP.isEmpty()) {
            source.method_45068(class_2561.method_43470("No biome densities loaded!").method_27692(class_124.field_1061));
            source.method_45068(class_2561.method_43470("Check that datapack files exist at:").method_27692(class_124.field_1080));
            source.method_45068(class_2561.method_43470("  data/<namespace>/aether_densities/biome/<biome_path>.json").method_27692(class_124.field_1080));
        } else {
            source.method_45068(class_2561.method_43470("Loaded " + BiomeAetherDensityManager.DENSITY_MAP.size() + " biome densities:").method_27692(class_124.field_1060));
            
            for (Map.Entry<class_2960, AetherDensity> entry : BiomeAetherDensityManager.DENSITY_MAP.entrySet()) {
                source.method_45068(class_2561.method_43470("---").method_27692(class_124.field_1080));
                source.method_45068(class_2561.method_43470("Biome: " + entry.getKey().toString()).method_27692(class_124.field_1054));
                
                AetherDensity density = entry.getValue();
                if (density.getDensities().isEmpty()) {
                    source.method_45068(class_2561.method_43470("  Empty density").method_27692(class_124.field_1080));
                } else {
                    for (Map.Entry<class_2960, Double> aspectEntry : density.getDensities().entrySet()) {
                        source.method_45068(class_2561.method_43470(
                                String.format("  %s: %.2f", aspectEntry.getKey().toString(), aspectEntry.getValue())
                        ).method_27692(class_124.field_1075));
                    }
                }
            }
        }
        
        return 1;
    }

    private static int addCorruption(CommandContext<class_2168> context, double amount) {
        class_2168 source = context.getSource();

        if (source.method_9228() instanceof class_3222 player) {
            class_1937 world = player.method_37908();
            class_2338 pos = player.method_24515();
            class_2960 biomeId = world.method_23753(pos).method_40230().orElseThrow().method_29177();

            DynamicAetherDensityManager.addModification(biomeId, VITIUM_ASPECT, amount);

            CorruptionManager.addCorruptionSource(biomeId, pos, 5);
            player.method_43496(class_2561.method_43470("Added " + amount + " vitium corruption to biome: " + biomeId).method_27692(class_124.field_1079));
            player.method_43496(class_2561.method_43470("Use /" + AspectsLib.MOD_ID + ":aether_density report to see the current state").method_27692(class_124.field_1080));

            return 1;
        }

        source.method_9213(class_2561.method_43470("This command can only be used by players"));
        return 0;
    }
}