package dev.overgrown.aspectslib.data;

import com.google.gson.*;
import dev.overgrown.aspectslib.AspectsLib;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class EntityAspectManager extends class_4309 implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public EntityAspectManager() {
        super(GSON, "entity_aspects");
    }

    @Override
    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        EntityAspectRegistry.clear();

        for (Map.Entry<class_2960, JsonElement> entry : prepared.entrySet()) {
            class_2960 fileId = entry.getKey();
            JsonObject json = entry.getValue().getAsJsonObject();

            try {
                class_2960 entityId = new class_2960(json.get("entity").getAsString());
                JsonObject aspectsObj = json.getAsJsonObject("aspects");

                Object2IntOpenHashMap<class_2960> aspects = new Object2IntOpenHashMap<>();
                for (Map.Entry<String, JsonElement> aspectEntry : aspectsObj.entrySet()) {
                    class_2960 aspectId = new class_2960(aspectEntry.getKey());
                    int amount = aspectEntry.getValue().getAsInt();
                    aspects.put(aspectId, amount);
                }

                EntityAspectRegistry.register(entityId, new AspectData(aspects));
            } catch (Exception e) {
                AspectsLib.LOGGER.error("Error loading entity aspects from {}: {}", fileId, e.getMessage());
            }
        }
        AspectsLib.LOGGER.info("Loaded {} entity aspect mappings", prepared.size());
    }

    @Override
    public class_2960 getFabricId() {
        return AspectsLib.identifier("entity_aspects");
    }

    @Override
    public Collection<class_2960> getFabricDependencies() {
        return List.of(AspectsLib.identifier("aspects"));
    }
}