package dev.overgrown.aspectslib.data;

import java.util.*;
import net.minecraft.class_2960;

public class EntityAspectRegistry {
    private static final Map<class_2960, AspectData> ID_TO_ASPECT = new HashMap<>();

    public static void register(class_2960 entityId, AspectData data) {
        ID_TO_ASPECT.put(entityId, data);
    }

    public static AspectData get(class_2960 entityId) {
        return ID_TO_ASPECT.getOrDefault(entityId, AspectData.DEFAULT);
    }

    public static void clear() {
        ID_TO_ASPECT.clear();
    }
}